@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property featureName The name of a feature. `feature_name` cannot be any of the following: `is_deleted`, `write_time`, `api_invocation_time`.
 * @property featureType The value type of a feature. Valid values are `Integral`, `Fractional`, or `String`.
 */
public data class FeatureGroupFeatureDefinition(
    public val featureName: String? = null,
    public val featureType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.FeatureGroupFeatureDefinition): FeatureGroupFeatureDefinition = FeatureGroupFeatureDefinition(
            featureName = javaType.featureName().map({ args0 -> args0 }).orElse(null),
            featureType = javaType.featureType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
