@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId The AWS Key Management Service (KMS) key ID of the key used to encrypt any objects written into the OfflineStore S3 location.
 * @property resolvedOutputS3Uri The S3 path where offline records are written.
 * @property s3Uri The S3 URI, or location in Amazon S3, of OfflineStore.
 */
public data class FeatureGroupOfflineStoreConfigS3StorageConfig(
    public val kmsKeyId: String? = null,
    public val resolvedOutputS3Uri: String? = null,
    public val s3Uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.FeatureGroupOfflineStoreConfigS3StorageConfig): FeatureGroupOfflineStoreConfigS3StorageConfig =
            FeatureGroupOfflineStoreConfigS3StorageConfig(
                kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
                resolvedOutputS3Uri = javaType.resolvedOutputS3Uri().map({ args0 -> args0 }).orElse(null),
                s3Uri = javaType.s3Uri(),
            )
    }
}
