@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enableOnlineStore Set to `true` to disable the automatic creation of an AWS Glue table when configuring an OfflineStore.
 * @property securityConfig Security config for at-rest encryption of your OnlineStore. See Security Config Below.
 * @property storageType Option for different tiers of low latency storage for real-time data retrieval. Valid values are `Standard`, or `InMemory`.
 * @property ttlDuration Time to live duration, where the record is hard deleted after the expiration time is reached; ExpiresAt = EventTime + TtlDuration.. See TTl Duration Below.
 */
public data class FeatureGroupOnlineStoreConfig(
    public val enableOnlineStore: Boolean? = null,
    public val securityConfig: FeatureGroupOnlineStoreConfigSecurityConfig? = null,
    public val storageType: String? = null,
    public val ttlDuration: FeatureGroupOnlineStoreConfigTtlDuration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.FeatureGroupOnlineStoreConfig): FeatureGroupOnlineStoreConfig = FeatureGroupOnlineStoreConfig(
            enableOnlineStore = javaType.enableOnlineStore().map({ args0 -> args0 }).orElse(null),
            securityConfig = javaType.securityConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.FeatureGroupOnlineStoreConfigSecurityConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageType = javaType.storageType().map({ args0 -> args0 }).orElse(null),
            ttlDuration = javaType.ttlDuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.FeatureGroupOnlineStoreConfigTtlDuration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
