@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property humanTaskUiArn The Amazon Resource Name (ARN) of the human task user interface.
 * @property publicWorkforceTaskPrice Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed. See Public Workforce Task Price details below.
 * @property taskAvailabilityLifetimeInSeconds The length of time that a task remains available for review by human workers. Valid value range between `1` and `864000`.
 * @property taskCount The number of distinct workers who will perform the same task on each object. Valid value range between `1` and `3`.
 * @property taskDescription A description for the human worker task.
 * @property taskKeywords An array of keywords used to describe the task so that workers can discover the task.
 * @property taskTimeLimitInSeconds The amount of time that a worker has to complete a task. The default value is `3600` seconds.
 * @property taskTitle A title for the human worker task.
 * @property workteamArn The Amazon Resource Name (ARN) of the human task user interface. Amazon Resource Name (ARN) of a team of workers. For Public workforces see [AWS Docs](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management-public.html).
 */
public data class FlowDefinitionHumanLoopConfig(
    public val humanTaskUiArn: String,
    public val publicWorkforceTaskPrice: FlowDefinitionHumanLoopConfigPublicWorkforceTaskPrice? =
        null,
    public val taskAvailabilityLifetimeInSeconds: Int? = null,
    public val taskCount: Int,
    public val taskDescription: String,
    public val taskKeywords: List<String>? = null,
    public val taskTimeLimitInSeconds: Int? = null,
    public val taskTitle: String,
    public val workteamArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.FlowDefinitionHumanLoopConfig): FlowDefinitionHumanLoopConfig = FlowDefinitionHumanLoopConfig(
            humanTaskUiArn = javaType.humanTaskUiArn(),
            publicWorkforceTaskPrice = javaType.publicWorkforceTaskPrice().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPrice.Companion.toKotlin(args0)
                })
            }).orElse(null),
            taskAvailabilityLifetimeInSeconds = javaType.taskAvailabilityLifetimeInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            taskCount = javaType.taskCount(),
            taskDescription = javaType.taskDescription(),
            taskKeywords = javaType.taskKeywords().map({ args0 -> args0 }),
            taskTimeLimitInSeconds = javaType.taskTimeLimitInSeconds().map({ args0 -> args0 }).orElse(null),
            taskTitle = javaType.taskTitle(),
            workteamArn = javaType.workteamArn(),
        )
    }
}
