@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property cents The fractional portion, in cents, of the amount. Valid value range between `0` and `99`.
 * @property dollars The whole number of dollars in the amount. Valid value range between `0` and `2`.
 * @property tenthFractionsOfACent Fractions of a cent, in tenths. Valid value range between `0` and `9`.
 */
public data class FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsd(
    public val cents: Int? = null,
    public val dollars: Int? = null,
    public val tenthFractionsOfACent: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsd): FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsd =
            FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsd(
                cents = javaType.cents().map({ args0 -> args0 }).orElse(null),
                dollars = javaType.dollars().map({ args0 -> args0 }).orElse(null),
                tenthFractionsOfACent = javaType.tenthFractionsOfACent().map({ args0 -> args0 }).orElse(null),
            )
    }
}
