@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The content of the Liquid template for the worker user interface.
 * @property contentSha256 The SHA-256 digest of the contents of the template.
 * @property url The URL for the user interface template.
 */
public data class HumanTaskUIUiTemplate(
    public val content: String? = null,
    public val contentSha256: String? = null,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.HumanTaskUIUiTemplate): HumanTaskUIUiTemplate = HumanTaskUIUiTemplate(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            contentSha256 = javaType.contentSha256().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
