@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property containerHostname The DNS host name for the container.
 * @property environment Environment variables for the Docker container.
 * A list of key value pairs.
 * @property image The registry path where the inference code image is stored in Amazon ECR.
 * @property imageConfig Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
 * @property mode The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
 * @property modelDataSource The location of model data to deploy. Use this for uncompressed model deployment. For information about how to deploy an uncompressed model, see [Deploying uncompressed models](https://docs.aws.amazon.com/sagemaker/latest/dg/large-model-inference-uncompressed.html) in the _AWS SageMaker Developer Guide_.
 * @property modelDataUrl The URL for the S3 location where model artifacts are stored.
 * @property modelPackageName The Amazon Resource Name (ARN) of the model package to use to create the model.
 */
public data class ModelPrimaryContainer(
    public val containerHostname: String? = null,
    public val environment: Map<String, String>? = null,
    public val image: String? = null,
    public val imageConfig: ModelPrimaryContainerImageConfig? = null,
    public val mode: String? = null,
    public val modelDataSource: ModelPrimaryContainerModelDataSource? = null,
    public val modelDataUrl: String? = null,
    public val modelPackageName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.ModelPrimaryContainer): ModelPrimaryContainer = ModelPrimaryContainer(
            containerHostname = javaType.containerHostname().map({ args0 -> args0 }).orElse(null),
            environment = javaType.environment().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            imageConfig = javaType.imageConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.ModelPrimaryContainerImageConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            modelDataSource = javaType.modelDataSource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.ModelPrimaryContainerModelDataSource.Companion.toKotlin(args0)
                })
            }).orElse(null),
            modelDataUrl = javaType.modelDataUrl().map({ args0 -> args0 }).orElse(null),
            modelPackageName = javaType.modelPackageName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
