@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property compressionType How the model data is prepared. Allowed values are: `None` and `Gzip`.
 * @property s3DataType The type of model data to deploy. Allowed values are: `S3Object` and `S3Prefix`.
 * @property s3Uri The S3 path of model data to deploy.
 */
public data class ModelPrimaryContainerModelDataSourceS3DataSource(
    public val compressionType: String,
    public val s3DataType: String,
    public val s3Uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.ModelPrimaryContainerModelDataSourceS3DataSource): ModelPrimaryContainerModelDataSourceS3DataSource =
            ModelPrimaryContainerModelDataSourceS3DataSource(
                compressionType = javaType.compressionType(),
                s3DataType = javaType.s3DataType(),
                s3Uri = javaType.s3Uri(),
            )
    }
}
