@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket Name of the S3 bucket.
 * @property objectKey The object key (or key name) uniquely identifies the object in an S3 bucket.
 * @property versionId Version Id of the pipeline definition file. If not specified, Amazon SageMaker will retrieve the latest version.
 */
public data class PipelinePipelineDefinitionS3Location(
    public val bucket: String,
    public val objectKey: String,
    public val versionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.PipelinePipelineDefinitionS3Location): PipelinePipelineDefinitionS3Location = PipelinePipelineDefinitionS3Location(
            bucket = javaType.bucket(),
            objectKey = javaType.objectKey(),
            versionId = javaType.versionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
