@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property appType The type of app created within the space.
 * @property codeEditorAppSettings The Code Editor application settings. See `code_editor_app_settings` Block below.
 * @property customFileSystems A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. See `custom_file_system` Block below.
 * @property jupyterLabAppSettings The settings for the JupyterLab application. See `jupyter_lab_app_settings` Block below.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
 * @property spaceStorageSettings The storage settings. See `space_storage_settings` Block below.
 */
public data class SpaceSpaceSettings(
    public val appType: String? = null,
    public val codeEditorAppSettings: SpaceSpaceSettingsCodeEditorAppSettings? = null,
    public val customFileSystems: List<SpaceSpaceSettingsCustomFileSystem>? = null,
    public val jupyterLabAppSettings: SpaceSpaceSettingsJupyterLabAppSettings? = null,
    public val jupyterServerAppSettings: SpaceSpaceSettingsJupyterServerAppSettings? = null,
    public val kernelGatewayAppSettings: SpaceSpaceSettingsKernelGatewayAppSettings? = null,
    public val spaceStorageSettings: SpaceSpaceSettingsSpaceStorageSettings? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.SpaceSpaceSettings): SpaceSpaceSettings = SpaceSpaceSettings(
            appType = javaType.appType().map({ args0 -> args0 }).orElse(null),
            codeEditorAppSettings = javaType.codeEditorAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsCodeEditorAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customFileSystems = javaType.customFileSystems().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsCustomFileSystem.Companion.toKotlin(args0)
                })
            }),
            jupyterLabAppSettings = javaType.jupyterLabAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsJupyterLabAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jupyterServerAppSettings = javaType.jupyterServerAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsJupyterServerAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kernelGatewayAppSettings = javaType.kernelGatewayAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsKernelGatewayAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            spaceStorageSettings = javaType.spaceStorageSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsSpaceStorageSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
