@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
 */
public data class SpaceSpaceSettingsJupyterLabAppSettings(
    public val codeRepositories: List<SpaceSpaceSettingsJupyterLabAppSettingsCodeRepository>? = null,
    public val defaultResourceSpec: SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpec,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.SpaceSpaceSettingsJupyterLabAppSettings): SpaceSpaceSettingsJupyterLabAppSettings = SpaceSpaceSettingsJupyterLabAppSettings(
            codeRepositories = javaType.codeRepositories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsJupyterLabAppSettingsCodeRepository.Companion.toKotlin(args0)
                })
            }),
            defaultResourceSpec = javaType.defaultResourceSpec().let({ args0 ->
                com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpec.Companion.toKotlin(args0)
            }),
        )
    }
}
