@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceType The instance type.
 * @property lifecycleConfigArn The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
 * @property sagemakerImageArn The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
 * @property sagemakerImageVersionAlias The SageMaker Image Version Alias.
 * @property sagemakerImageVersionArn The ARN of the image version created on the instance.
 */
public data class SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpec(
    public val instanceType: String? = null,
    public val lifecycleConfigArn: String? = null,
    public val sagemakerImageArn: String? = null,
    public val sagemakerImageVersionAlias: String? = null,
    public val sagemakerImageVersionArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpec): SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpec =
            SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpec(
                instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
                lifecycleConfigArn = javaType.lifecycleConfigArn().map({ args0 -> args0 }).orElse(null),
                sagemakerImageArn = javaType.sagemakerImageArn().map({ args0 -> args0 }).orElse(null),
                sagemakerImageVersionAlias = javaType.sagemakerImageVersionAlias().map({ args0 ->
                    args0
                }).orElse(null),
                sagemakerImageVersionArn = javaType.sagemakerImageVersionArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
