@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a KernelGateway app. See `custom_image` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class SpaceSpaceSettingsKernelGatewayAppSettings(
    public val customImages: List<SpaceSpaceSettingsKernelGatewayAppSettingsCustomImage>? = null,
    public val defaultResourceSpec: SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpec,
    public val lifecycleConfigArns: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.SpaceSpaceSettingsKernelGatewayAppSettings): SpaceSpaceSettingsKernelGatewayAppSettings = SpaceSpaceSettingsKernelGatewayAppSettings(
            customImages = javaType.customImages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsKernelGatewayAppSettingsCustomImage.Companion.toKotlin(args0)
                })
            }),
            defaultResourceSpec = javaType.defaultResourceSpec().let({ args0 ->
                com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpec.Companion.toKotlin(args0)
            }),
            lifecycleConfigArns = javaType.lifecycleConfigArns().map({ args0 -> args0 }),
        )
    }
}
