@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property canvasAppSettings The Canvas app settings. See Canvas App Settings below.
 * @property codeEditorAppSettings The Code Editor application settings. See Code Editor App Settings below.
 * @property customFileSystemConfigs The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See Custom File System Config below.
 * @property customPosixUserConfig Details about the POSIX identity that is used for file system operations. See Custom Posix User Config below.
 * @property defaultLandingUri The default experience that the user is directed to when accessing the domain. The supported values are: `studio::`: Indicates that Studio is the default experience. This value can only be passed if StudioWebPortal is set to ENABLED. `app:JupyterServer:`: Indicates that Studio Classic is the default experience.
 * @property executionRole The execution role ARN for the user.
 * @property jupyterLabAppSettings The settings for the JupyterLab application. See Jupyter Lab App Settings below.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See Jupyter Server App Settings below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See Kernel Gateway App Settings below.
 * @property rSessionAppSettings The RSession app settings. See RSession App Settings below.
 * @property rStudioServerProAppSettings A collection of settings that configure user interaction with the RStudioServerPro app. See RStudioServerProAppSettings below.
 * @property securityGroups A list of security group IDs that will be attached to the user.
 * @property sharingSettings The sharing settings. See Sharing Settings below.
 * @property spaceStorageSettings The storage settings for a private space. See Space Storage Settings below.
 * @property studioWebPortal Whether the user can access Studio. If this value is set to `DISABLED`, the user cannot access Studio, even if that is the default experience for the domain. Valid values are `ENABLED` and `DISABLED`.
 * @property tensorBoardAppSettings The TensorBoard app settings. See TensorBoard App Settings below.
 */
public data class UserProfileUserSettings(
    public val canvasAppSettings: UserProfileUserSettingsCanvasAppSettings? = null,
    public val codeEditorAppSettings: UserProfileUserSettingsCodeEditorAppSettings? = null,
    public val customFileSystemConfigs: List<UserProfileUserSettingsCustomFileSystemConfig>? = null,
    public val customPosixUserConfig: UserProfileUserSettingsCustomPosixUserConfig? = null,
    public val defaultLandingUri: String? = null,
    public val executionRole: String,
    public val jupyterLabAppSettings: UserProfileUserSettingsJupyterLabAppSettings? = null,
    public val jupyterServerAppSettings: UserProfileUserSettingsJupyterServerAppSettings? = null,
    public val kernelGatewayAppSettings: UserProfileUserSettingsKernelGatewayAppSettings? = null,
    public val rSessionAppSettings: UserProfileUserSettingsRSessionAppSettings? = null,
    public val rStudioServerProAppSettings: UserProfileUserSettingsRStudioServerProAppSettings? =
        null,
    public val securityGroups: List<String>? = null,
    public val sharingSettings: UserProfileUserSettingsSharingSettings? = null,
    public val spaceStorageSettings: UserProfileUserSettingsSpaceStorageSettings? = null,
    public val studioWebPortal: String? = null,
    public val tensorBoardAppSettings: UserProfileUserSettingsTensorBoardAppSettings? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.UserProfileUserSettings): UserProfileUserSettings = UserProfileUserSettings(
            canvasAppSettings = javaType.canvasAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCanvasAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            codeEditorAppSettings = javaType.codeEditorAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCodeEditorAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customFileSystemConfigs = javaType.customFileSystemConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCustomFileSystemConfig.Companion.toKotlin(args0)
                })
            }),
            customPosixUserConfig = javaType.customPosixUserConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCustomPosixUserConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultLandingUri = javaType.defaultLandingUri().map({ args0 -> args0 }).orElse(null),
            executionRole = javaType.executionRole(),
            jupyterLabAppSettings = javaType.jupyterLabAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsJupyterLabAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jupyterServerAppSettings = javaType.jupyterServerAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsJupyterServerAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kernelGatewayAppSettings = javaType.kernelGatewayAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsKernelGatewayAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rSessionAppSettings = javaType.rSessionAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsRSessionAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rStudioServerProAppSettings = javaType.rStudioServerProAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsRStudioServerProAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            sharingSettings = javaType.sharingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsSharingSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            spaceStorageSettings = javaType.spaceStorageSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsSpaceStorageSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            studioWebPortal = javaType.studioWebPortal().map({ args0 -> args0 }).orElse(null),
            tensorBoardAppSettings = javaType.tensorBoardAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsTensorBoardAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
