@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a CodeEditor app. see Custom Image below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class UserProfileUserSettingsCodeEditorAppSettings(
    public val customImages: List<UserProfileUserSettingsCodeEditorAppSettingsCustomImage>? = null,
    public val defaultResourceSpec: UserProfileUserSettingsCodeEditorAppSettingsDefaultResourceSpec? =
        null,
    public val lifecycleConfigArns: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.UserProfileUserSettingsCodeEditorAppSettings): UserProfileUserSettingsCodeEditorAppSettings = UserProfileUserSettingsCodeEditorAppSettings(
            customImages = javaType.customImages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCodeEditorAppSettingsCustomImage.Companion.toKotlin(args0)
                })
            }),
            defaultResourceSpec = javaType.defaultResourceSpec().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCodeEditorAppSettingsDefaultResourceSpec.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lifecycleConfigArns = javaType.lifecycleConfigArns().map({ args0 -> args0 }),
        )
    }
}
