@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fileSystemId The ID of your Amazon EFS file system.
 * @property fileSystemPath The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.
 */
public data class UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfig(
    public val fileSystemId: String,
    public val fileSystemPath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfig): UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfig =
            UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfig(
                fileSystemId = javaType.fileSystemId(),
                fileSystemPath = javaType.fileSystemPath().map({ args0 -> args0 }).orElse(null),
            )
    }
}
