@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
 * @property customImages
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class UserProfileUserSettingsJupyterLabAppSettings(
    public val codeRepositories: List<UserProfileUserSettingsJupyterLabAppSettingsCodeRepository>? =
        null,
    public val customImages: List<UserProfileUserSettingsJupyterLabAppSettingsCustomImage>? = null,
    public val defaultResourceSpec: UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpec? =
        null,
    public val lifecycleConfigArns: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.UserProfileUserSettingsJupyterLabAppSettings): UserProfileUserSettingsJupyterLabAppSettings = UserProfileUserSettingsJupyterLabAppSettings(
            codeRepositories = javaType.codeRepositories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsJupyterLabAppSettingsCodeRepository.Companion.toKotlin(args0)
                })
            }),
            customImages = javaType.customImages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsJupyterLabAppSettingsCustomImage.Companion.toKotlin(args0)
                })
            }),
            defaultResourceSpec = javaType.defaultResourceSpec().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpec.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lifecycleConfigArns = javaType.lifecycleConfigArns().map({ args0 -> args0 }),
        )
    }
}
