@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property authenticationRequestExtraParams A string to string map of identifiers specific to the custom identity provider (IdP) being used.
 * @property authorizationEndpoint The OIDC IdP authorization endpoint used to configure your private workforce.
 * @property clientId The OIDC IdP client ID used to configure your private workforce.
 * @property clientSecret The OIDC IdP client secret used to configure your private workforce.
 * @property issuer The OIDC IdP issuer used to configure your private workforce.
 * @property jwksUri The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
 * @property logoutEndpoint The OIDC IdP logout endpoint used to configure your private workforce.
 * @property scope An array of string identifiers used to refer to the specific pieces of user data or claims that the client application wants to access.
 * @property tokenEndpoint The OIDC IdP token endpoint used to configure your private workforce.
 * @property userInfoEndpoint The OIDC IdP user information endpoint used to configure your private workforce.
 */
public data class WorkforceOidcConfig(
    public val authenticationRequestExtraParams: Map<String, String>? = null,
    public val authorizationEndpoint: String,
    public val clientId: String,
    public val clientSecret: String,
    public val issuer: String,
    public val jwksUri: String,
    public val logoutEndpoint: String,
    public val scope: String? = null,
    public val tokenEndpoint: String,
    public val userInfoEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.WorkforceOidcConfig): WorkforceOidcConfig = WorkforceOidcConfig(
            authenticationRequestExtraParams = javaType.authenticationRequestExtraParams().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            authorizationEndpoint = javaType.authorizationEndpoint(),
            clientId = javaType.clientId(),
            clientSecret = javaType.clientSecret(),
            issuer = javaType.issuer(),
            jwksUri = javaType.jwksUri(),
            logoutEndpoint = javaType.logoutEndpoint(),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            tokenEndpoint = javaType.tokenEndpoint(),
            userInfoEndpoint = javaType.userInfoEndpoint(),
        )
    }
}
