@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds The VPC security group IDs. The security groups must be for the same VPC as specified in the subnet.
 * @property subnets The ID of the subnets in the VPC that you want to connect.
 * @property vpcEndpointId The IDs for the VPC service endpoints of your VPC workforce.
 * @property vpcId The ID of the VPC that the workforce uses for communication.
 */
public data class WorkforceWorkforceVpcConfig(
    public val securityGroupIds: List<String>? = null,
    public val subnets: List<String>? = null,
    public val vpcEndpointId: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.WorkforceWorkforceVpcConfig): WorkforceWorkforceVpcConfig = WorkforceWorkforceVpcConfig(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnets = javaType.subnets().map({ args0 -> args0 }),
            vpcEndpointId = javaType.vpcEndpointId().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
