@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property sourceIp When SourceIp is Enabled the worker's IP address when a task is rendered in the worker portal is added to the IAM policy as a Condition used to generate the Amazon S3 presigned URL. This IP address is checked by Amazon S3 and must match in order for the Amazon S3 resource to be rendered in the worker portal. Valid values are `Enabled` or `Disabled`
 * @property vpcSourceIp When VpcSourceIp is Enabled the worker's IP address when a task is rendered in private worker portal inside the VPC is added to the IAM policy as a Condition used to generate the Amazon S3 presigned URL. To render the task successfully Amazon S3 checks that the presigned URL is being accessed over an Amazon S3 VPC Endpoint, and that the worker's IP address matches the IP address in the IAM policy. To learn more about configuring private worker portal, see [Use Amazon VPC mode from a private worker portal](https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html). Valid values are `Enabled` or `Disabled`
 */
public data class WorkteamWorkerAccessConfigurationS3PresignIamPolicyConstraints(
    public val sourceIp: String? = null,
    public val vpcSourceIp: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.WorkteamWorkerAccessConfigurationS3PresignIamPolicyConstraints): WorkteamWorkerAccessConfigurationS3PresignIamPolicyConstraints =
            WorkteamWorkerAccessConfigurationS3PresignIamPolicyConstraints(
                sourceIp = javaType.sourceIp().map({ args0 -> args0 }).orElse(null),
                vpcSourceIp = javaType.vpcSourceIp().map({ args0 -> args0 }).orElse(null),
            )
    }
}
