@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ScheduleGroup].
 */
@PulumiTagMarker
public class ScheduleGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduleGroupArgs = ScheduleGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduleGroupArgsBuilder.() -> Unit) {
        val builder = ScheduleGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScheduleGroup {
        val builtJavaResource = com.pulumi.aws.scheduler.ScheduleGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ScheduleGroup(builtJavaResource)
    }
}

/**
 * Provides an EventBridge Scheduler Schedule Group resource.
 * You can find out more about EventBridge Scheduler in the [User Guide](https://docs.aws.amazon.com/scheduler/latest/UserGuide/what-is-scheduler.html).
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.scheduler.ScheduleGroup("example", {name: "my-schedule-group"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.scheduler.ScheduleGroup("example", name="my-schedule-group")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Scheduler.ScheduleGroup("example", new()
 *     {
 *         Name = "my-schedule-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/scheduler"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scheduler.NewScheduleGroup(ctx, "example", &scheduler.ScheduleGroupArgs{
 * 			Name: pulumi.String("my-schedule-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.scheduler.ScheduleGroup;
 * import com.pulumi.aws.scheduler.ScheduleGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ScheduleGroup("example", ScheduleGroupArgs.builder()
 *             .name("my-schedule-group")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:scheduler:ScheduleGroup
 *     properties:
 *       name: my-schedule-group
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import schedule groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:scheduler/scheduleGroup:ScheduleGroup example my-schedule-group
 * ```
 */
public class ScheduleGroup internal constructor(
    override val javaResource: com.pulumi.aws.scheduler.ScheduleGroup,
) : KotlinCustomResource(javaResource, ScheduleGroupMapper) {
    /**
     * ARN of the schedule group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Time at which the schedule group was created.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Time at which the schedule group was last modified.
     */
    public val lastModificationDate: Output<String>
        get() = javaResource.lastModificationDate().applyValue({ args0 -> args0 })

    /**
     * Name of the schedule group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * State of the schedule group. Can be `ACTIVE` or `DELETING`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ScheduleGroupMapper : ResourceMapper<ScheduleGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.scheduler.ScheduleGroup::class == javaResource::class

    override fun map(javaResource: Resource): ScheduleGroup = ScheduleGroup(
        javaResource as
            com.pulumi.aws.scheduler.ScheduleGroup,
    )
}

/**
 * @see [ScheduleGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScheduleGroup].
 */
public suspend fun scheduleGroup(
    name: String,
    block: suspend ScheduleGroupResourceBuilder.() -> Unit,
): ScheduleGroup {
    val builder = ScheduleGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScheduleGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scheduleGroup(name: String): ScheduleGroup {
    val builder = ScheduleGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
