@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin

import com.pulumi.aws.scheduler.ScheduleGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge Scheduler Schedule Group resource.
 * You can find out more about EventBridge Scheduler in the [User Guide](https://docs.aws.amazon.com/scheduler/latest/UserGuide/what-is-scheduler.html).
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.scheduler.ScheduleGroup("example", {name: "my-schedule-group"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.scheduler.ScheduleGroup("example", name="my-schedule-group")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Scheduler.ScheduleGroup("example", new()
 *     {
 *         Name = "my-schedule-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/scheduler"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scheduler.NewScheduleGroup(ctx, "example", &scheduler.ScheduleGroupArgs{
 * 			Name: pulumi.String("my-schedule-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.scheduler.ScheduleGroup;
 * import com.pulumi.aws.scheduler.ScheduleGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ScheduleGroup("example", ScheduleGroupArgs.builder()
 *             .name("my-schedule-group")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:scheduler:ScheduleGroup
 *     properties:
 *       name: my-schedule-group
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import schedule groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:scheduler/scheduleGroup:ScheduleGroup example my-schedule-group
 * ```
 * @property name Name of the schedule group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ScheduleGroupArgs(
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.scheduler.ScheduleGroupArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.ScheduleGroupArgs =
        com.pulumi.aws.scheduler.ScheduleGroupArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ScheduleGroupArgs].
 */
@PulumiTagMarker
public class ScheduleGroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the schedule group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("hujmkkpwyllrqqpi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("xetbcqplbwgyowex")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gettcmfjmkogiinu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the schedule group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("lyomtbqfbfxnyvuk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("vkrxwlfvnmhqqsgg")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tohcalhjytjospkh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("povqwcvmywphefkr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ScheduleGroupArgs = ScheduleGroupArgs(
        name = name,
        namePrefix = namePrefix,
        tags = tags,
    )
}
