@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleFlexibleTimeWindowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumWindowInMinutes Maximum time window during which a schedule can be invoked. Ranges from `1` to `1440` minutes.
 * @property mode Determines whether the schedule is invoked within a flexible time window. One of: `OFF`, `FLEXIBLE`.
 */
public data class ScheduleFlexibleTimeWindowArgs(
    public val maximumWindowInMinutes: Output<Int>? = null,
    public val mode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleFlexibleTimeWindowArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleFlexibleTimeWindowArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleFlexibleTimeWindowArgs.builder()
            .maximumWindowInMinutes(maximumWindowInMinutes?.applyValue({ args0 -> args0 }))
            .mode(mode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleFlexibleTimeWindowArgs].
 */
@PulumiTagMarker
public class ScheduleFlexibleTimeWindowArgsBuilder internal constructor() {
    private var maximumWindowInMinutes: Output<Int>? = null

    private var mode: Output<String>? = null

    /**
     * @param value Maximum time window during which a schedule can be invoked. Ranges from `1` to `1440` minutes.
     */
    @JvmName("cukkjvlfbanevxuy")
    public suspend fun maximumWindowInMinutes(`value`: Output<Int>) {
        this.maximumWindowInMinutes = value
    }

    /**
     * @param value Determines whether the schedule is invoked within a flexible time window. One of: `OFF`, `FLEXIBLE`.
     */
    @JvmName("gwnawscgajyhxqnu")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Maximum time window during which a schedule can be invoked. Ranges from `1` to `1440` minutes.
     */
    @JvmName("kunkywowbqhfmbwc")
    public suspend fun maximumWindowInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumWindowInMinutes = mapped
    }

    /**
     * @param value Determines whether the schedule is invoked within a flexible time window. One of: `OFF`, `FLEXIBLE`.
     */
    @JvmName("foqheybjyjjlwqvt")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): ScheduleFlexibleTimeWindowArgs = ScheduleFlexibleTimeWindowArgs(
        maximumWindowInMinutes = maximumWindowInMinutes,
        mode = mode ?: throw PulumiNullFieldException("mode"),
    )
}
