@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property capacityProviderStrategies Up to `6` capacity provider strategies to use for the task. Detailed below.
 * @property enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon ECS Developer Guide.
 * @property enableExecuteCommand Specifies whether to enable the execute command functionality for the containers in this task.
 * @property group Specifies an ECS task group for the task. At most 255 characters.
 * @property launchType Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. One of: `EC2`, `FARGATE`, `EXTERNAL`.
 * @property networkConfiguration Configures the networking associated with the task. Detailed below.
 * @property placementConstraints A set of up to 10 placement constraints to use for the task. Detailed below.
 * @property placementStrategies A set of up to 5 placement strategies. Detailed below.
 * @property platformVersion Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`.
 * @property propagateTags Specifies whether to propagate the tags from the task definition to the task. One of: `TASK_DEFINITION`.
 * @property referenceId Reference ID to use for the task.
 * @property tags The metadata that you apply to the task. Each tag consists of a key and an optional value. For more information, see [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) in the Amazon ECS API Reference.
 * @property taskCount The number of tasks to create. Ranges from `1` (default) to `10`.
 * @property taskDefinitionArn ARN of the task definition to use.
 * The following arguments are optional:
 */
public data class ScheduleTargetEcsParametersArgs(
    public val capacityProviderStrategies: Output<List<ScheduleTargetEcsParametersCapacityProviderStrategyArgs>>? = null,
    public val enableEcsManagedTags: Output<Boolean>? = null,
    public val enableExecuteCommand: Output<Boolean>? = null,
    public val group: Output<String>? = null,
    public val launchType: Output<String>? = null,
    public val networkConfiguration: Output<ScheduleTargetEcsParametersNetworkConfigurationArgs>? =
        null,
    public val placementConstraints: Output<List<ScheduleTargetEcsParametersPlacementConstraintArgs>>? =
        null,
    public val placementStrategies: Output<List<ScheduleTargetEcsParametersPlacementStrategyArgs>>? =
        null,
    public val platformVersion: Output<String>? = null,
    public val propagateTags: Output<String>? = null,
    public val referenceId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taskCount: Output<Int>? = null,
    public val taskDefinitionArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersArgs.builder()
            .capacityProviderStrategies(
                capacityProviderStrategies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableEcsManagedTags(enableEcsManagedTags?.applyValue({ args0 -> args0 }))
            .enableExecuteCommand(enableExecuteCommand?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .launchType(launchType?.applyValue({ args0 -> args0 }))
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .placementConstraints(
                placementConstraints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .placementStrategies(
                placementStrategies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .platformVersion(platformVersion?.applyValue({ args0 -> args0 }))
            .propagateTags(propagateTags?.applyValue({ args0 -> args0 }))
            .referenceId(referenceId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taskCount(taskCount?.applyValue({ args0 -> args0 }))
            .taskDefinitionArn(taskDefinitionArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTargetEcsParametersArgs].
 */
@PulumiTagMarker
public class ScheduleTargetEcsParametersArgsBuilder internal constructor() {
    private var capacityProviderStrategies:
        Output<List<ScheduleTargetEcsParametersCapacityProviderStrategyArgs>>? = null

    private var enableEcsManagedTags: Output<Boolean>? = null

    private var enableExecuteCommand: Output<Boolean>? = null

    private var group: Output<String>? = null

    private var launchType: Output<String>? = null

    private var networkConfiguration: Output<ScheduleTargetEcsParametersNetworkConfigurationArgs>? =
        null

    private var placementConstraints:
        Output<List<ScheduleTargetEcsParametersPlacementConstraintArgs>>? = null

    private var placementStrategies: Output<List<ScheduleTargetEcsParametersPlacementStrategyArgs>>? =
        null

    private var platformVersion: Output<String>? = null

    private var propagateTags: Output<String>? = null

    private var referenceId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taskCount: Output<Int>? = null

    private var taskDefinitionArn: Output<String>? = null

    /**
     * @param value Up to `6` capacity provider strategies to use for the task. Detailed below.
     */
    @JvmName("mjanndofavgrhpjn")
    public suspend fun capacityProviderStrategies(`value`: Output<List<ScheduleTargetEcsParametersCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = value
    }

    @JvmName("quwmelaqhvlipwos")
    public suspend fun capacityProviderStrategies(vararg values: Output<ScheduleTargetEcsParametersCapacityProviderStrategyArgs>) {
        this.capacityProviderStrategies = Output.all(values.asList())
    }

    /**
     * @param values Up to `6` capacity provider strategies to use for the task. Detailed below.
     */
    @JvmName("blchywjbkpsrymxy")
    public suspend fun capacityProviderStrategies(values: List<Output<ScheduleTargetEcsParametersCapacityProviderStrategyArgs>>) {
        this.capacityProviderStrategies = Output.all(values)
    }

    /**
     * @param value Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon ECS Developer Guide.
     */
    @JvmName("mmgootwcdsbefeax")
    public suspend fun enableEcsManagedTags(`value`: Output<Boolean>) {
        this.enableEcsManagedTags = value
    }

    /**
     * @param value Specifies whether to enable the execute command functionality for the containers in this task.
     */
    @JvmName("xuggiiuphckeevdq")
    public suspend fun enableExecuteCommand(`value`: Output<Boolean>) {
        this.enableExecuteCommand = value
    }

    /**
     * @param value Specifies an ECS task group for the task. At most 255 characters.
     */
    @JvmName("rbwokvgkphhglfcw")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. One of: `EC2`, `FARGATE`, `EXTERNAL`.
     */
    @JvmName("wshsiwkdvfewfyjo")
    public suspend fun launchType(`value`: Output<String>) {
        this.launchType = value
    }

    /**
     * @param value Configures the networking associated with the task. Detailed below.
     */
    @JvmName("onvcpyocpwtpxayc")
    public suspend fun networkConfiguration(`value`: Output<ScheduleTargetEcsParametersNetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value A set of up to 10 placement constraints to use for the task. Detailed below.
     */
    @JvmName("vejvtwyrwjufscdf")
    public suspend fun placementConstraints(`value`: Output<List<ScheduleTargetEcsParametersPlacementConstraintArgs>>) {
        this.placementConstraints = value
    }

    @JvmName("pblkdgrltnmssdyj")
    public suspend fun placementConstraints(vararg values: Output<ScheduleTargetEcsParametersPlacementConstraintArgs>) {
        this.placementConstraints = Output.all(values.asList())
    }

    /**
     * @param values A set of up to 10 placement constraints to use for the task. Detailed below.
     */
    @JvmName("pjjdoaebrwjhbtxr")
    public suspend fun placementConstraints(values: List<Output<ScheduleTargetEcsParametersPlacementConstraintArgs>>) {
        this.placementConstraints = Output.all(values)
    }

    /**
     * @param value A set of up to 5 placement strategies. Detailed below.
     */
    @JvmName("wjbwlxhsprreomkm")
    public suspend fun placementStrategies(`value`: Output<List<ScheduleTargetEcsParametersPlacementStrategyArgs>>) {
        this.placementStrategies = value
    }

    @JvmName("pcuhfxqrmqcyqlqr")
    public suspend fun placementStrategies(vararg values: Output<ScheduleTargetEcsParametersPlacementStrategyArgs>) {
        this.placementStrategies = Output.all(values.asList())
    }

    /**
     * @param values A set of up to 5 placement strategies. Detailed below.
     */
    @JvmName("mhfwuiwquuapcoxo")
    public suspend fun placementStrategies(values: List<Output<ScheduleTargetEcsParametersPlacementStrategyArgs>>) {
        this.placementStrategies = Output.all(values)
    }

    /**
     * @param value Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`.
     */
    @JvmName("aucjerimfbffwqea")
    public suspend fun platformVersion(`value`: Output<String>) {
        this.platformVersion = value
    }

    /**
     * @param value Specifies whether to propagate the tags from the task definition to the task. One of: `TASK_DEFINITION`.
     */
    @JvmName("emctwhapjujcqjte")
    public suspend fun propagateTags(`value`: Output<String>) {
        this.propagateTags = value
    }

    /**
     * @param value Reference ID to use for the task.
     */
    @JvmName("ywvjecbwbeilpusl")
    public suspend fun referenceId(`value`: Output<String>) {
        this.referenceId = value
    }

    /**
     * @param value The metadata that you apply to the task. Each tag consists of a key and an optional value. For more information, see [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) in the Amazon ECS API Reference.
     */
    @JvmName("yelxqgdeptjyckqm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of tasks to create. Ranges from `1` (default) to `10`.
     */
    @JvmName("fbhpfpudcfhftciv")
    public suspend fun taskCount(`value`: Output<Int>) {
        this.taskCount = value
    }

    /**
     * @param value ARN of the task definition to use.
     * The following arguments are optional:
     */
    @JvmName("hdgcowonmpxqkflt")
    public suspend fun taskDefinitionArn(`value`: Output<String>) {
        this.taskDefinitionArn = value
    }

    /**
     * @param value Up to `6` capacity provider strategies to use for the task. Detailed below.
     */
    @JvmName("dswewgmaamckxlbd")
    public suspend fun capacityProviderStrategies(`value`: List<ScheduleTargetEcsParametersCapacityProviderStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Up to `6` capacity provider strategies to use for the task. Detailed below.
     */
    @JvmName("qwtgbywdxuilioei")
    public suspend fun capacityProviderStrategies(argument: List<suspend ScheduleTargetEcsParametersCapacityProviderStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScheduleTargetEcsParametersCapacityProviderStrategyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Up to `6` capacity provider strategies to use for the task. Detailed below.
     */
    @JvmName("gwdonowrjmqtrfsa")
    public suspend fun capacityProviderStrategies(vararg argument: suspend ScheduleTargetEcsParametersCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScheduleTargetEcsParametersCapacityProviderStrategyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param argument Up to `6` capacity provider strategies to use for the task. Detailed below.
     */
    @JvmName("ygnjbknpiejbwqqv")
    public suspend fun capacityProviderStrategies(argument: suspend ScheduleTargetEcsParametersCapacityProviderStrategyArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ScheduleTargetEcsParametersCapacityProviderStrategyArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param values Up to `6` capacity provider strategies to use for the task. Detailed below.
     */
    @JvmName("bjgkjvcxoetxympj")
    public suspend fun capacityProviderStrategies(vararg values: ScheduleTargetEcsParametersCapacityProviderStrategyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProviderStrategies = mapped
    }

    /**
     * @param value Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon ECS Developer Guide.
     */
    @JvmName("smoasowfapshcuct")
    public suspend fun enableEcsManagedTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEcsManagedTags = mapped
    }

    /**
     * @param value Specifies whether to enable the execute command functionality for the containers in this task.
     */
    @JvmName("syylallefuviekrb")
    public suspend fun enableExecuteCommand(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableExecuteCommand = mapped
    }

    /**
     * @param value Specifies an ECS task group for the task. At most 255 characters.
     */
    @JvmName("aoffqnjlcscewuei")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. One of: `EC2`, `FARGATE`, `EXTERNAL`.
     */
    @JvmName("iwoisgxxbofxsnrs")
    public suspend fun launchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchType = mapped
    }

    /**
     * @param value Configures the networking associated with the task. Detailed below.
     */
    @JvmName("leulamveylwabkll")
    public suspend fun networkConfiguration(`value`: ScheduleTargetEcsParametersNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument Configures the networking associated with the task. Detailed below.
     */
    @JvmName("ilaxjqmthejuelry")
    public suspend fun networkConfiguration(argument: suspend ScheduleTargetEcsParametersNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduleTargetEcsParametersNetworkConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value A set of up to 10 placement constraints to use for the task. Detailed below.
     */
    @JvmName("jhvhaawftrtefpge")
    public suspend fun placementConstraints(`value`: List<ScheduleTargetEcsParametersPlacementConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param argument A set of up to 10 placement constraints to use for the task. Detailed below.
     */
    @JvmName("mrvyohqgkliejieh")
    public suspend fun placementConstraints(argument: List<suspend ScheduleTargetEcsParametersPlacementConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScheduleTargetEcsParametersPlacementConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument A set of up to 10 placement constraints to use for the task. Detailed below.
     */
    @JvmName("puieuivbdskbpsyc")
    public suspend fun placementConstraints(vararg argument: suspend ScheduleTargetEcsParametersPlacementConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScheduleTargetEcsParametersPlacementConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param argument A set of up to 10 placement constraints to use for the task. Detailed below.
     */
    @JvmName("muixtwhkkjhuybxn")
    public suspend fun placementConstraints(argument: suspend ScheduleTargetEcsParametersPlacementConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScheduleTargetEcsParametersPlacementConstraintArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.placementConstraints = mapped
    }

    /**
     * @param values A set of up to 10 placement constraints to use for the task. Detailed below.
     */
    @JvmName("kbnganhcinvivoqa")
    public suspend fun placementConstraints(vararg values: ScheduleTargetEcsParametersPlacementConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param value A set of up to 5 placement strategies. Detailed below.
     */
    @JvmName("xqbjicqrhyeghgbg")
    public suspend fun placementStrategies(`value`: List<ScheduleTargetEcsParametersPlacementStrategyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementStrategies = mapped
    }

    /**
     * @param argument A set of up to 5 placement strategies. Detailed below.
     */
    @JvmName("jcqeymyvhmupqnyk")
    public suspend fun placementStrategies(argument: List<suspend ScheduleTargetEcsParametersPlacementStrategyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScheduleTargetEcsParametersPlacementStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.placementStrategies = mapped
    }

    /**
     * @param argument A set of up to 5 placement strategies. Detailed below.
     */
    @JvmName("bbtmerdmoxogcihu")
    public suspend fun placementStrategies(vararg argument: suspend ScheduleTargetEcsParametersPlacementStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScheduleTargetEcsParametersPlacementStrategyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.placementStrategies = mapped
    }

    /**
     * @param argument A set of up to 5 placement strategies. Detailed below.
     */
    @JvmName("pbcnobwwedsmgpmj")
    public suspend fun placementStrategies(argument: suspend ScheduleTargetEcsParametersPlacementStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScheduleTargetEcsParametersPlacementStrategyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.placementStrategies = mapped
    }

    /**
     * @param values A set of up to 5 placement strategies. Detailed below.
     */
    @JvmName("hmianjxjdvpifckl")
    public suspend fun placementStrategies(vararg values: ScheduleTargetEcsParametersPlacementStrategyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementStrategies = mapped
    }

    /**
     * @param value Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`.
     */
    @JvmName("slgnlyakspvbwiyy")
    public suspend fun platformVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformVersion = mapped
    }

    /**
     * @param value Specifies whether to propagate the tags from the task definition to the task. One of: `TASK_DEFINITION`.
     */
    @JvmName("fcygrpovyhkibysa")
    public suspend fun propagateTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagateTags = mapped
    }

    /**
     * @param value Reference ID to use for the task.
     */
    @JvmName("qbbbkbgheqobokkx")
    public suspend fun referenceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceId = mapped
    }

    /**
     * @param value The metadata that you apply to the task. Each tag consists of a key and an optional value. For more information, see [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) in the Amazon ECS API Reference.
     */
    @JvmName("ulmllnspsvykseji")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The metadata that you apply to the task. Each tag consists of a key and an optional value. For more information, see [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) in the Amazon ECS API Reference.
     */
    @JvmName("jmgypxwovpdiebum")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The number of tasks to create. Ranges from `1` (default) to `10`.
     */
    @JvmName("qpmqnjsmjovcudxb")
    public suspend fun taskCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskCount = mapped
    }

    /**
     * @param value ARN of the task definition to use.
     * The following arguments are optional:
     */
    @JvmName("vbgcavfxqxnblsna")
    public suspend fun taskDefinitionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskDefinitionArn = mapped
    }

    internal fun build(): ScheduleTargetEcsParametersArgs = ScheduleTargetEcsParametersArgs(
        capacityProviderStrategies = capacityProviderStrategies,
        enableEcsManagedTags = enableEcsManagedTags,
        enableExecuteCommand = enableExecuteCommand,
        group = group,
        launchType = launchType,
        networkConfiguration = networkConfiguration,
        placementConstraints = placementConstraints,
        placementStrategies = placementStrategies,
        platformVersion = platformVersion,
        propagateTags = propagateTags,
        referenceId = referenceId,
        tags = tags,
        taskCount = taskCount,
        taskDefinitionArn = taskDefinitionArn ?: throw PulumiNullFieldException("taskDefinitionArn"),
    )
}
