@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersCapacityProviderStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property base How many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Ranges from `0` (default) to `100000`.
 * @property capacityProvider Short name of the capacity provider.
 * @property weight Designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Ranges from from `0` to `1000`.
 */
public data class ScheduleTargetEcsParametersCapacityProviderStrategyArgs(
    public val base: Output<Int>? = null,
    public val capacityProvider: Output<String>,
    public val weight: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersCapacityProviderStrategyArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersCapacityProviderStrategyArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersCapacityProviderStrategyArgs.builder()
            .base(base?.applyValue({ args0 -> args0 }))
            .capacityProvider(capacityProvider.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTargetEcsParametersCapacityProviderStrategyArgs].
 */
@PulumiTagMarker
public class ScheduleTargetEcsParametersCapacityProviderStrategyArgsBuilder internal constructor() {
    private var base: Output<Int>? = null

    private var capacityProvider: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value How many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Ranges from `0` (default) to `100000`.
     */
    @JvmName("nscpetcxwjymbegd")
    public suspend fun base(`value`: Output<Int>) {
        this.base = value
    }

    /**
     * @param value Short name of the capacity provider.
     */
    @JvmName("frrqiltihgwkrpyx")
    public suspend fun capacityProvider(`value`: Output<String>) {
        this.capacityProvider = value
    }

    /**
     * @param value Designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Ranges from from `0` to `1000`.
     */
    @JvmName("uwrghepqfwokbxka")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value How many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Ranges from `0` (default) to `100000`.
     */
    @JvmName("ygtixtuaojhfstuc")
    public suspend fun base(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.base = mapped
    }

    /**
     * @param value Short name of the capacity provider.
     */
    @JvmName("cdxanursehwbfobs")
    public suspend fun capacityProvider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacityProvider = mapped
    }

    /**
     * @param value Designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Ranges from from `0` to `1000`.
     */
    @JvmName("qqdlpscujksfynyj")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ScheduleTargetEcsParametersCapacityProviderStrategyArgs =
        ScheduleTargetEcsParametersCapacityProviderStrategyArgs(
            base = base,
            capacityProvider = capacityProvider ?: throw PulumiNullFieldException("capacityProvider"),
            weight = weight,
        )
}
