@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property assignPublicIp Specifies whether the task's elastic network interface receives a public IP address. This attribute is a boolean type, where `true` maps to `ENABLED` and `false` to `DISABLED`. You can specify `true` only when the `launch_type` is set to `FARGATE`.
 * @property securityGroups Set of 1 to 5 Security Group ID-s to be associated with the task. These security groups must all be in the same VPC.
 * @property subnets Set of 1 to 16 subnets to be associated with the task. These subnets must all be in the same VPC.
 */
public data class ScheduleTargetEcsParametersNetworkConfigurationArgs(
    public val assignPublicIp: Output<Boolean>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val subnets: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersNetworkConfigurationArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersNetworkConfigurationArgs.builder()
            .assignPublicIp(assignPublicIp?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ScheduleTargetEcsParametersNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class ScheduleTargetEcsParametersNetworkConfigurationArgsBuilder internal constructor() {
    private var assignPublicIp: Output<Boolean>? = null

    private var securityGroups: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value Specifies whether the task's elastic network interface receives a public IP address. This attribute is a boolean type, where `true` maps to `ENABLED` and `false` to `DISABLED`. You can specify `true` only when the `launch_type` is set to `FARGATE`.
     */
    @JvmName("lyyfoxfeljidrgpx")
    public suspend fun assignPublicIp(`value`: Output<Boolean>) {
        this.assignPublicIp = value
    }

    /**
     * @param value Set of 1 to 5 Security Group ID-s to be associated with the task. These security groups must all be in the same VPC.
     */
    @JvmName("adxnyjbhulcxdump")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("xympnyaxthscxuth")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values Set of 1 to 5 Security Group ID-s to be associated with the task. These security groups must all be in the same VPC.
     */
    @JvmName("ixbckbrsxenprbwd")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value Set of 1 to 16 subnets to be associated with the task. These subnets must all be in the same VPC.
     */
    @JvmName("tpgmubllkfctpnqb")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("mowgiyprfcmbgxmx")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values Set of 1 to 16 subnets to be associated with the task. These subnets must all be in the same VPC.
     */
    @JvmName("wkwckqaorbwyitmb")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Specifies whether the task's elastic network interface receives a public IP address. This attribute is a boolean type, where `true` maps to `ENABLED` and `false` to `DISABLED`. You can specify `true` only when the `launch_type` is set to `FARGATE`.
     */
    @JvmName("npisfugbjyuppvhq")
    public suspend fun assignPublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignPublicIp = mapped
    }

    /**
     * @param value Set of 1 to 5 Security Group ID-s to be associated with the task. These security groups must all be in the same VPC.
     */
    @JvmName("rkbtliurxngwphxr")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values Set of 1 to 5 Security Group ID-s to be associated with the task. These security groups must all be in the same VPC.
     */
    @JvmName("pfivpelvhcplhjwo")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value Set of 1 to 16 subnets to be associated with the task. These subnets must all be in the same VPC.
     */
    @JvmName("axivdnipotjwkluq")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values Set of 1 to 16 subnets to be associated with the task. These subnets must all be in the same VPC.
     */
    @JvmName("vawtnuvxqscdagxs")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build(): ScheduleTargetEcsParametersNetworkConfigurationArgs =
        ScheduleTargetEcsParametersNetworkConfigurationArgs(
            assignPublicIp = assignPublicIp,
            securityGroups = securityGroups,
            subnets = subnets ?: throw PulumiNullFieldException("subnets"),
        )
}
