@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetEventbridgeParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property detailType Free-form string used to decide what fields to expect in the event detail. Up to 128 characters.
 * @property source Source of the event.
 */
public data class ScheduleTargetEventbridgeParametersArgs(
    public val detailType: Output<String>,
    public val source: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetEventbridgeParametersArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleTargetEventbridgeParametersArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetEventbridgeParametersArgs.builder()
            .detailType(detailType.applyValue({ args0 -> args0 }))
            .source(source.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTargetEventbridgeParametersArgs].
 */
@PulumiTagMarker
public class ScheduleTargetEventbridgeParametersArgsBuilder internal constructor() {
    private var detailType: Output<String>? = null

    private var source: Output<String>? = null

    /**
     * @param value Free-form string used to decide what fields to expect in the event detail. Up to 128 characters.
     */
    @JvmName("kdcgvepqibhabvcq")
    public suspend fun detailType(`value`: Output<String>) {
        this.detailType = value
    }

    /**
     * @param value Source of the event.
     */
    @JvmName("nunsihhtrrsvroxe")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Free-form string used to decide what fields to expect in the event detail. Up to 128 characters.
     */
    @JvmName("meulqwbigeheknba")
    public suspend fun detailType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.detailType = mapped
    }

    /**
     * @param value Source of the event.
     */
    @JvmName("rsphputvqhekktna")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): ScheduleTargetEventbridgeParametersArgs =
        ScheduleTargetEventbridgeParametersArgs(
            detailType = detailType ?: throw PulumiNullFieldException("detailType"),
            source = source ?: throw PulumiNullFieldException("source"),
        )
}
