@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetSagemakerPipelineParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property pipelineParameters Set of up to 200 parameter names and values to use when executing the SageMaker Model Building Pipeline. Detailed below.
 */
public data class ScheduleTargetSagemakerPipelineParametersArgs(
    public val pipelineParameters: Output<List<ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetSagemakerPipelineParametersArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleTargetSagemakerPipelineParametersArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetSagemakerPipelineParametersArgs.builder()
            .pipelineParameters(
                pipelineParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScheduleTargetSagemakerPipelineParametersArgs].
 */
@PulumiTagMarker
public class ScheduleTargetSagemakerPipelineParametersArgsBuilder internal constructor() {
    private var pipelineParameters:
        Output<List<ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs>>? = null

    /**
     * @param value Set of up to 200 parameter names and values to use when executing the SageMaker Model Building Pipeline. Detailed below.
     */
    @JvmName("pmvraxjcnfmxxkyq")
    public suspend fun pipelineParameters(`value`: Output<List<ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs>>) {
        this.pipelineParameters = value
    }

    @JvmName("tdgydruerslxxtub")
    public suspend fun pipelineParameters(vararg values: Output<ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs>) {
        this.pipelineParameters = Output.all(values.asList())
    }

    /**
     * @param values Set of up to 200 parameter names and values to use when executing the SageMaker Model Building Pipeline. Detailed below.
     */
    @JvmName("oalhnyufnndvbvte")
    public suspend fun pipelineParameters(values: List<Output<ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs>>) {
        this.pipelineParameters = Output.all(values)
    }

    /**
     * @param value Set of up to 200 parameter names and values to use when executing the SageMaker Model Building Pipeline. Detailed below.
     */
    @JvmName("flfddgtodbryaxtj")
    public suspend fun pipelineParameters(`value`: List<ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineParameters = mapped
    }

    /**
     * @param argument Set of up to 200 parameter names and values to use when executing the SageMaker Model Building Pipeline. Detailed below.
     */
    @JvmName("payfgqkxscmjkeqy")
    public suspend fun pipelineParameters(argument: List<suspend ScheduleTargetSagemakerPipelineParametersPipelineParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScheduleTargetSagemakerPipelineParametersPipelineParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelineParameters = mapped
    }

    /**
     * @param argument Set of up to 200 parameter names and values to use when executing the SageMaker Model Building Pipeline. Detailed below.
     */
    @JvmName("boeiblswtqcosord")
    public suspend fun pipelineParameters(vararg argument: suspend ScheduleTargetSagemakerPipelineParametersPipelineParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScheduleTargetSagemakerPipelineParametersPipelineParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelineParameters = mapped
    }

    /**
     * @param argument Set of up to 200 parameter names and values to use when executing the SageMaker Model Building Pipeline. Detailed below.
     */
    @JvmName("qugvtkbxrrfxkodx")
    public suspend fun pipelineParameters(argument: suspend ScheduleTargetSagemakerPipelineParametersPipelineParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ScheduleTargetSagemakerPipelineParametersPipelineParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.pipelineParameters = mapped
    }

    /**
     * @param values Set of up to 200 parameter names and values to use when executing the SageMaker Model Building Pipeline. Detailed below.
     */
    @JvmName("uohwwcutudukdrvg")
    public suspend fun pipelineParameters(vararg values: ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelineParameters = mapped
    }

    internal fun build(): ScheduleTargetSagemakerPipelineParametersArgs =
        ScheduleTargetSagemakerPipelineParametersArgs(
            pipelineParameters = pipelineParameters,
        )
}
