@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of parameter to start execution of a SageMaker Model Building Pipeline.
 * @property value Value of parameter to start execution of a SageMaker Model Building Pipeline.
 */
public data class ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs].
 */
@PulumiTagMarker
public class ScheduleTargetSagemakerPipelineParametersPipelineParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of parameter to start execution of a SageMaker Model Building Pipeline.
     */
    @JvmName("itdchowbwhgkkobv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline.
     */
    @JvmName("wdsakqqbsmhevyyl")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of parameter to start execution of a SageMaker Model Building Pipeline.
     */
    @JvmName("ciwwrywwjvkfkrix")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline.
     */
    @JvmName("ccaldfqhwccniufc")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs =
        ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
