@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetSqsParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property messageGroupId FIFO message group ID to use as the target.
 */
public data class ScheduleTargetSqsParametersArgs(
    public val messageGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetSqsParametersArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleTargetSqsParametersArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetSqsParametersArgs.builder()
            .messageGroupId(messageGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTargetSqsParametersArgs].
 */
@PulumiTagMarker
public class ScheduleTargetSqsParametersArgsBuilder internal constructor() {
    private var messageGroupId: Output<String>? = null

    /**
     * @param value FIFO message group ID to use as the target.
     */
    @JvmName("rbftoauimwrgelbv")
    public suspend fun messageGroupId(`value`: Output<String>) {
        this.messageGroupId = value
    }

    /**
     * @param value FIFO message group ID to use as the target.
     */
    @JvmName("rmfxaxeqhmlpfbmm")
    public suspend fun messageGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageGroupId = mapped
    }

    internal fun build(): ScheduleTargetSqsParametersArgs = ScheduleTargetSqsParametersArgs(
        messageGroupId = messageGroupId,
    )
}
