@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property assignPublicIp Specifies whether the task's elastic network interface receives a public IP address. This attribute is a boolean type, where `true` maps to `ENABLED` and `false` to `DISABLED`. You can specify `true` only when the `launch_type` is set to `FARGATE`.
 * @property securityGroups Set of 1 to 5 Security Group ID-s to be associated with the task. These security groups must all be in the same VPC.
 * @property subnets Set of 1 to 16 subnets to be associated with the task. These subnets must all be in the same VPC.
 */
public data class ScheduleTargetEcsParametersNetworkConfiguration(
    public val assignPublicIp: Boolean? = null,
    public val securityGroups: List<String>? = null,
    public val subnets: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.scheduler.outputs.ScheduleTargetEcsParametersNetworkConfiguration): ScheduleTargetEcsParametersNetworkConfiguration =
            ScheduleTargetEcsParametersNetworkConfiguration(
                assignPublicIp = javaType.assignPublicIp().map({ args0 -> args0 }).orElse(null),
                securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
                subnets = javaType.subnets().map({ args0 -> args0 }),
            )
    }
}
