@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property expression A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance`. For more information, see [Cluster query language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon ECS Developer Guide.
 * @property type The type of constraint. One of: `distinctInstance`, `memberOf`.
 */
public data class ScheduleTargetEcsParametersPlacementConstraint(
    public val expression: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.scheduler.outputs.ScheduleTargetEcsParametersPlacementConstraint): ScheduleTargetEcsParametersPlacementConstraint =
            ScheduleTargetEcsParametersPlacementConstraint(
                expression = javaType.expression().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
