@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.schemas.kotlin

import com.pulumi.aws.schemas.DiscovererArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge Schema Discoverer resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const messenger = new aws.cloudwatch.EventBus("messenger", {name: "chat-messages"});
 * const test = new aws.schemas.Discoverer("test", {
 *     sourceArn: messenger.arn,
 *     description: "Auto discover event schemas",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * messenger = aws.cloudwatch.EventBus("messenger", name="chat-messages")
 * test = aws.schemas.Discoverer("test",
 *     source_arn=messenger.arn,
 *     description="Auto discover event schemas")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var messenger = new Aws.CloudWatch.EventBus("messenger", new()
 *     {
 *         Name = "chat-messages",
 *     });
 *     var test = new Aws.Schemas.Discoverer("test", new()
 *     {
 *         SourceArn = messenger.Arn,
 *         Description = "Auto discover event schemas",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/schemas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		messenger, err := cloudwatch.NewEventBus(ctx, "messenger", &cloudwatch.EventBusArgs{
 * 			Name: pulumi.String("chat-messages"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = schemas.NewDiscoverer(ctx, "test", &schemas.DiscovererArgs{
 * 			SourceArn:   messenger.Arn,
 * 			Description: pulumi.String("Auto discover event schemas"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import com.pulumi.aws.cloudwatch.EventBusArgs;
 * import com.pulumi.aws.schemas.Discoverer;
 * import com.pulumi.aws.schemas.DiscovererArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var messenger = new EventBus("messenger", EventBusArgs.builder()
 *             .name("chat-messages")
 *             .build());
 *         var test = new Discoverer("test", DiscovererArgs.builder()
 *             .sourceArn(messenger.arn())
 *             .description("Auto discover event schemas")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   messenger:
 *     type: aws:cloudwatch:EventBus
 *     properties:
 *       name: chat-messages
 *   test:
 *     type: aws:schemas:Discoverer
 *     properties:
 *       sourceArn: ${messenger.arn}
 *       description: Auto discover event schemas
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EventBridge discoverers using the `id`. For example:
 * ```sh
 * $ pulumi import aws:schemas/discoverer:Discoverer test 123
 * ```
 * @property description The description of the discoverer. Maximum of 256 characters.
 * @property sourceArn The ARN of the event bus to discover event schemas on.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DiscovererArgs(
    public val description: Output<String>? = null,
    public val sourceArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.schemas.DiscovererArgs> {
    override fun toJava(): com.pulumi.aws.schemas.DiscovererArgs =
        com.pulumi.aws.schemas.DiscovererArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .sourceArn(sourceArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DiscovererArgs].
 */
@PulumiTagMarker
public class DiscovererArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var sourceArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the discoverer. Maximum of 256 characters.
     */
    @JvmName("rcbduauniimmbgfw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ARN of the event bus to discover event schemas on.
     */
    @JvmName("fsciwhgvohhjcoxd")
    public suspend fun sourceArn(`value`: Output<String>) {
        this.sourceArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ebtikyrhlwvelrho")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the discoverer. Maximum of 256 characters.
     */
    @JvmName("rcimbcjesymotpfq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ARN of the event bus to discover event schemas on.
     */
    @JvmName("ifjgeemdsfdumvls")
    public suspend fun sourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("amhlpgpsmvdywjjs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bpqclxjckwryfpkg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DiscovererArgs = DiscovererArgs(
        description = description,
        sourceArn = sourceArn,
        tags = tags,
    )
}
