@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.schemas.kotlin

import com.pulumi.aws.schemas.SchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge Schema resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.schemas.Registry("test", {name: "my_own_registry"});
 * const testSchema = new aws.schemas.Schema("test", {
 *     name: "my_schema",
 *     registryName: test.name,
 *     type: "OpenApi3",
 *     description: "The schema definition for my event",
 *     content: JSON.stringify({
 *         openapi: "3.0.0",
 *         info: {
 *             version: "1.0.0",
 *             title: "Event",
 *         },
 *         paths: {},
 *         components: {
 *             schemas: {
 *                 Event: {
 *                     type: "object",
 *                     properties: {
 *                         name: {
 *                             type: "string",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * test = aws.schemas.Registry("test", name="my_own_registry")
 * test_schema = aws.schemas.Schema("test",
 *     name="my_schema",
 *     registry_name=test.name,
 *     type="OpenApi3",
 *     description="The schema definition for my event",
 *     content=json.dumps({
 *         "openapi": "3.0.0",
 *         "info": {
 *             "version": "1.0.0",
 *             "title": "Event",
 *         },
 *         "paths": {},
 *         "components": {
 *             "schemas": {
 *                 "Event": {
 *                     "type": "object",
 *                     "properties": {
 *                         "name": {
 *                             "type": "string",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Schemas.Registry("test", new()
 *     {
 *         Name = "my_own_registry",
 *     });
 *     var testSchema = new Aws.Schemas.Schema("test", new()
 *     {
 *         Name = "my_schema",
 *         RegistryName = test.Name,
 *         Type = "OpenApi3",
 *         Description = "The schema definition for my event",
 *         Content = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["openapi"] = "3.0.0",
 *             ["info"] = new Dictionary<string, object?>
 *             {
 *                 ["version"] = "1.0.0",
 *                 ["title"] = "Event",
 *             },
 *             ["paths"] = new Dictionary<string, object?>
 *             {
 *             },
 *             ["components"] = new Dictionary<string, object?>
 *             {
 *                 ["schemas"] = new Dictionary<string, object?>
 *                 {
 *                     ["Event"] = new Dictionary<string, object?>
 *                     {
 *                         ["type"] = "object",
 *                         ["properties"] = new Dictionary<string, object?>
 *                         {
 *                             ["name"] = new Dictionary<string, object?>
 *                             {
 *                                 ["type"] = "string",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/schemas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := schemas.NewRegistry(ctx, "test", &schemas.RegistryArgs{
 * 			Name: pulumi.String("my_own_registry"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"openapi": "3.0.0",
 * 			"info": map[string]interface{}{
 * 				"version": "1.0.0",
 * 				"title":   "Event",
 * 			},
 * 			"paths": nil,
 * 			"components": map[string]interface{}{
 * 				"schemas": map[string]interface{}{
 * 					"Event": map[string]interface{}{
 * 						"type": "object",
 * 						"properties": map[string]interface{}{
 * 							"name": map[string]interface{}{
 * 								"type": "string",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = schemas.NewSchema(ctx, "test", &schemas.SchemaArgs{
 * 			Name:         pulumi.String("my_schema"),
 * 			RegistryName: test.Name,
 * 			Type:         pulumi.String("OpenApi3"),
 * 			Description:  pulumi.String("The schema definition for my event"),
 * 			Content:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.schemas.Registry;
 * import com.pulumi.aws.schemas.RegistryArgs;
 * import com.pulumi.aws.schemas.Schema;
 * import com.pulumi.aws.schemas.SchemaArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Registry("test", RegistryArgs.builder()
 *             .name("my_own_registry")
 *             .build());
 *         var testSchema = new Schema("testSchema", SchemaArgs.builder()
 *             .name("my_schema")
 *             .registryName(test.name())
 *             .type("OpenApi3")
 *             .description("The schema definition for my event")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("openapi", "3.0.0"),
 *                     jsonProperty("info", jsonObject(
 *                         jsonProperty("version", "1.0.0"),
 *                         jsonProperty("title", "Event")
 *                     )),
 *                     jsonProperty("paths", jsonObject(
 *                     )),
 *                     jsonProperty("components", jsonObject(
 *                         jsonProperty("schemas", jsonObject(
 *                             jsonProperty("Event", jsonObject(
 *                                 jsonProperty("type", "object"),
 *                                 jsonProperty("properties", jsonObject(
 *                                     jsonProperty("name", jsonObject(
 *                                         jsonProperty("type", "string")
 *                                     ))
 *                                 ))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:schemas:Registry
 *     properties:
 *       name: my_own_registry
 *   testSchema:
 *     type: aws:schemas:Schema
 *     name: test
 *     properties:
 *       name: my_schema
 *       registryName: ${test.name}
 *       type: OpenApi3
 *       description: The schema definition for my event
 *       content:
 *         fn::toJSON:
 *           openapi: 3.0.0
 *           info:
 *             version: 1.0.0
 *             title: Event
 *           paths: {}
 *           components:
 *             schemas:
 *               Event:
 *                 type: object
 *                 properties:
 *                   name:
 *                     type: string
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EventBridge schema using the `name` and `registry_name`. For example:
 * ```sh
 * $ pulumi import aws:schemas/schema:Schema test name/registry
 * ```
 * @property content The schema specification. Must be a valid Open API 3.0 spec.
 * @property description The description of the schema. Maximum of 256 characters.
 * @property name The name of the schema. Maximum of 385 characters consisting of lower case letters, upper case letters, ., -, _, @.
 * @property registryName The name of the registry in which this schema belongs.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of the schema. Valid values: `OpenApi3` or `JSONSchemaDraft4`.
 */
public data class SchemaArgs(
    public val content: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.schemas.SchemaArgs> {
    override fun toJava(): com.pulumi.aws.schemas.SchemaArgs =
        com.pulumi.aws.schemas.SchemaArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SchemaArgs].
 */
@PulumiTagMarker
public class SchemaArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var registryName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The schema specification. Must be a valid Open API 3.0 spec.
     */
    @JvmName("hnvyowyhftibxcuo")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The description of the schema. Maximum of 256 characters.
     */
    @JvmName("ldhanvmgxuqcyltf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the schema. Maximum of 385 characters consisting of lower case letters, upper case letters, ., -, _, @.
     */
    @JvmName("flrtnmtnukwratbe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the registry in which this schema belongs.
     */
    @JvmName("xfhonybkiocvxajr")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aqeekhoceouhbwsj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of the schema. Valid values: `OpenApi3` or `JSONSchemaDraft4`.
     */
    @JvmName("jgesftcdmlmaixwd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The schema specification. Must be a valid Open API 3.0 spec.
     */
    @JvmName("wbvqpbribyckfbdc")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The description of the schema. Maximum of 256 characters.
     */
    @JvmName("heyxwfoceyciwdji")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the schema. Maximum of 385 characters consisting of lower case letters, upper case letters, ., -, _, @.
     */
    @JvmName("urvaljlkyqxysrvv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the registry in which this schema belongs.
     */
    @JvmName("sawfprrjaewkliyb")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("udwmnwnsqqhfstpb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kplsxxhsjkuisutv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of the schema. Valid values: `OpenApi3` or `JSONSchemaDraft4`.
     */
    @JvmName("youvrjocusylpvfa")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SchemaArgs = SchemaArgs(
        content = content,
        description = description,
        name = name,
        registryName = registryName,
        tags = tags,
        type = type,
    )
}
