@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin

import com.pulumi.aws.secretsmanager.SecretPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Secrets Manager secret policy.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleSecret = new aws.secretsmanager.Secret("example", {name: "example"});
 * const example = aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "EnableAnotherAWSAccountToReadTheSecret",
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["arn:aws:iam::123456789012:root"],
 *         }],
 *         actions: ["secretsmanager:GetSecretValue"],
 *         resources: ["*"],
 *     }],
 * });
 * const exampleSecretPolicy = new aws.secretsmanager.SecretPolicy("example", {
 *     secretArn: exampleSecret.arn,
 *     policy: example.then(example => example.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_secret = aws.secretsmanager.Secret("example", name="example")
 * example = aws.iam.get_policy_document(statements=[{
 *     "sid": "EnableAnotherAWSAccountToReadTheSecret",
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["arn:aws:iam::123456789012:root"],
 *     }],
 *     "actions": ["secretsmanager:GetSecretValue"],
 *     "resources": ["*"],
 * }])
 * example_secret_policy = aws.secretsmanager.SecretPolicy("example",
 *     secret_arn=example_secret.arn,
 *     policy=example.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleSecret = new Aws.SecretsManager.Secret("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "EnableAnotherAWSAccountToReadTheSecret",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "arn:aws:iam::123456789012:root",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "secretsmanager:GetSecretValue",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleSecretPolicy = new Aws.SecretsManager.SecretPolicy("example", new()
 *     {
 *         SecretArn = exampleSecret.Arn,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleSecret, err := secretsmanager.NewSecret(ctx, "example", &secretsmanager.SecretArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("EnableAnotherAWSAccountToReadTheSecret"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								"arn:aws:iam::123456789012:root",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"secretsmanager:GetSecretValue",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = secretsmanager.NewSecretPolicy(ctx, "example", &secretsmanager.SecretPolicyArgs{
 * 			SecretArn: exampleSecret.Arn,
 * 			Policy:    pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import com.pulumi.aws.secretsmanager.SecretArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.secretsmanager.SecretPolicy;
 * import com.pulumi.aws.secretsmanager.SecretPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSecret = new Secret("exampleSecret", SecretArgs.builder()
 *             .name("example")
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("EnableAnotherAWSAccountToReadTheSecret")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("arn:aws:iam::123456789012:root")
 *                     .build())
 *                 .actions("secretsmanager:GetSecretValue")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleSecretPolicy = new SecretPolicy("exampleSecretPolicy", SecretPolicyArgs.builder()
 *             .secretArn(exampleSecret.arn())
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleSecret:
 *     type: aws:secretsmanager:Secret
 *     name: example
 *     properties:
 *       name: example
 *   exampleSecretPolicy:
 *     type: aws:secretsmanager:SecretPolicy
 *     name: example
 *     properties:
 *       secretArn: ${exampleSecret.arn}
 *       policy: ${example.json}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: EnableAnotherAWSAccountToReadTheSecret
 *             effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - arn:aws:iam::123456789012:root
 *             actions:
 *               - secretsmanager:GetSecretValue
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_secretsmanager_secret_policy` using the secret Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:secretsmanager/secretPolicy:SecretPolicy example arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456
 * ```
 * @property blockPublicPolicy Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
 * @property policy Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `aws.secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
 * @property secretArn Secret ARN.
 * The following arguments are optional:
 */
public data class SecretPolicyArgs(
    public val blockPublicPolicy: Output<Boolean>? = null,
    public val policy: Output<String>? = null,
    public val secretArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.SecretPolicyArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.SecretPolicyArgs =
        com.pulumi.aws.secretsmanager.SecretPolicyArgs.builder()
            .blockPublicPolicy(blockPublicPolicy?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .secretArn(secretArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretPolicyArgs].
 */
@PulumiTagMarker
public class SecretPolicyArgsBuilder internal constructor() {
    private var blockPublicPolicy: Output<Boolean>? = null

    private var policy: Output<String>? = null

    private var secretArn: Output<String>? = null

    /**
     * @param value Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
     */
    @JvmName("ctphrqiotmqunbku")
    public suspend fun blockPublicPolicy(`value`: Output<Boolean>) {
        this.blockPublicPolicy = value
    }

    /**
     * @param value Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `aws.secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
     */
    @JvmName("ptanrblrgjklveln")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Secret ARN.
     * The following arguments are optional:
     */
    @JvmName("ttmdxxcdendyyjsn")
    public suspend fun secretArn(`value`: Output<String>) {
        this.secretArn = value
    }

    /**
     * @param value Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
     */
    @JvmName("hpnpvctgkdaclkme")
    public suspend fun blockPublicPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicPolicy = mapped
    }

    /**
     * @param value Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `aws.secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
     */
    @JvmName("vboydfnsgcfsmhhm")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Secret ARN.
     * The following arguments are optional:
     */
    @JvmName("vomtoodrnrkuhixq")
    public suspend fun secretArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretArn = mapped
    }

    internal fun build(): SecretPolicyArgs = SecretPolicyArgs(
        blockPublicPolicy = blockPublicPolicy,
        policy = policy,
        secretArn = secretArn,
    )
}
