@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin

import com.pulumi.aws.secretsmanager.kotlin.outputs.SecretRotationRotationRules
import com.pulumi.aws.secretsmanager.kotlin.outputs.SecretRotationRotationRules.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecretRotation].
 */
@PulumiTagMarker
public class SecretRotationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecretRotationArgs = SecretRotationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecretRotationArgsBuilder.() -> Unit) {
        val builder = SecretRotationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecretRotation {
        val builtJavaResource = com.pulumi.aws.secretsmanager.SecretRotation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecretRotation(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Secrets Manager secret rotation. To manage a secret, see the `aws.secretsmanager.Secret` resource. To manage a secret value, see the `aws.secretsmanager.SecretVersion` resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.secretsmanager.SecretRotation("example", {
 *     secretId: exampleAwsSecretsmanagerSecret.id,
 *     rotationLambdaArn: exampleAwsLambdaFunction.arn,
 *     rotationRules: {
 *         automaticallyAfterDays: 30,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.secretsmanager.SecretRotation("example",
 *     secret_id=example_aws_secretsmanager_secret["id"],
 *     rotation_lambda_arn=example_aws_lambda_function["arn"],
 *     rotation_rules={
 *         "automatically_after_days": 30,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecretsManager.SecretRotation("example", new()
 *     {
 *         SecretId = exampleAwsSecretsmanagerSecret.Id,
 *         RotationLambdaArn = exampleAwsLambdaFunction.Arn,
 *         RotationRules = new Aws.SecretsManager.Inputs.SecretRotationRotationRulesArgs
 *         {
 *             AutomaticallyAfterDays = 30,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := secretsmanager.NewSecretRotation(ctx, "example", &secretsmanager.SecretRotationArgs{
 * 			SecretId:          pulumi.Any(exampleAwsSecretsmanagerSecret.Id),
 * 			RotationLambdaArn: pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			RotationRules: &secretsmanager.SecretRotationRotationRulesArgs{
 * 				AutomaticallyAfterDays: pulumi.Int(30),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.SecretRotation;
 * import com.pulumi.aws.secretsmanager.SecretRotationArgs;
 * import com.pulumi.aws.secretsmanager.inputs.SecretRotationRotationRulesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecretRotation("example", SecretRotationArgs.builder()
 *             .secretId(exampleAwsSecretsmanagerSecret.id())
 *             .rotationLambdaArn(exampleAwsLambdaFunction.arn())
 *             .rotationRules(SecretRotationRotationRulesArgs.builder()
 *                 .automaticallyAfterDays(30)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:secretsmanager:SecretRotation
 *     properties:
 *       secretId: ${exampleAwsSecretsmanagerSecret.id}
 *       rotationLambdaArn: ${exampleAwsLambdaFunction.arn}
 *       rotationRules:
 *         automaticallyAfterDays: 30
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Rotation Configuration
 * To enable automatic secret rotation, the Secrets Manager service requires usage of a Lambda function. The [Rotate Secrets section in the Secrets Manager User Guide](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html) provides additional information about deploying a prebuilt Lambda functions for supported credential rotation (e.g., RDS) or deploying a custom Lambda function.
 * > **NOTE:** Configuring rotation causes the secret to rotate once as soon as you enable rotation. Before you do this, you must ensure that all of your applications that use the credentials stored in the secret are updated to retrieve the secret from AWS Secrets Manager. The old credentials might no longer be usable after the initial rotation and any applications that you fail to update will break as soon as the old credentials are no longer valid.
 * > **NOTE:** If you cancel a rotation that is in progress (by removing the `rotation` configuration), it can leave the VersionStage labels in an unexpected state. Depending on what step of the rotation was in progress, you might need to remove the staging label AWSPENDING from the partially created version, specified by the SecretVersionId response value. You should also evaluate the partially rotated new version to see if it should be deleted, which you can do by removing all staging labels from the new version's VersionStage field.
 * ## Import
 * Using `pulumi import`, import `aws_secretsmanager_secret_rotation` using the secret Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:secretsmanager/secretRotation:SecretRotation example arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456
 * ```
 */
public class SecretRotation internal constructor(
    override val javaResource: com.pulumi.aws.secretsmanager.SecretRotation,
) : KotlinCustomResource(javaResource, SecretRotationMapper) {
    /**
     * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. The rotation schedule is defined in `rotation_rules`. For secrets that use a Lambda rotation function to rotate, if you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the testSecret step (https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html) of the Lambda rotation function. The test creates an AWSPENDING version of the secret and then removes it. Defaults to `true`.
     */
    public val rotateImmediately: Output<Boolean>?
        get() = javaResource.rotateImmediately().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether automatic rotation is enabled for this secret.
     */
    public val rotationEnabled: Output<Boolean>
        get() = javaResource.rotationEnabled().applyValue({ args0 -> args0 })

    /**
     * Specifies the ARN of the Lambda function that can rotate the secret. Must be supplied if the secret is not managed by AWS.
     */
    public val rotationLambdaArn: Output<String>?
        get() = javaResource.rotationLambdaArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A structure that defines the rotation configuration for this secret. Defined below.
     */
    public val rotationRules: Output<SecretRotationRotationRules>
        get() = javaResource.rotationRules().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Specifies the secret to which you want to add a new version. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret. The secret must already exist.
     */
    public val secretId: Output<String>
        get() = javaResource.secretId().applyValue({ args0 -> args0 })
}

public object SecretRotationMapper : ResourceMapper<SecretRotation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.secretsmanager.SecretRotation::class == javaResource::class

    override fun map(javaResource: Resource): SecretRotation = SecretRotation(
        javaResource as
            com.pulumi.aws.secretsmanager.SecretRotation,
    )
}

/**
 * @see [SecretRotation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecretRotation].
 */
public suspend fun secretRotation(
    name: String,
    block: suspend SecretRotationResourceBuilder.() -> Unit,
): SecretRotation {
    val builder = SecretRotationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecretRotation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secretRotation(name: String): SecretRotation {
    val builder = SecretRotationResourceBuilder()
    builder.name(name)
    return builder.build()
}
