@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin

import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getRandomPasswordPlain
import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getSecretPlain
import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getSecretRotationPlain
import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getSecretVersionPlain
import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getSecretVersionsPlain
import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getSecretsPlain
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetRandomPasswordPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetRandomPasswordPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretRotationPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretRotationPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretVersionPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretVersionPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretVersionsPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretVersionsPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretsFilter
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretsPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretsPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetRandomPasswordResult
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretResult
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretRotationResult
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretVersionResult
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretVersionsResult
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetRandomPasswordResult.Companion.toKotlin as getRandomPasswordResultToKotlin
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretResult.Companion.toKotlin as getSecretResultToKotlin
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretRotationResult.Companion.toKotlin as getSecretRotationResultToKotlin
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretVersionResult.Companion.toKotlin as getSecretVersionResultToKotlin
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretVersionsResult.Companion.toKotlin as getSecretVersionsResultToKotlin
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretsResult.Companion.toKotlin as getSecretsResultToKotlin

public object SecretsmanagerFunctions {
    /**
     * Generate a random password.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.secretsmanager.getRandomPassword({
     *     passwordLength: 50,
     *     excludeNumbers: true,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.secretsmanager.get_random_password(password_length=50,
     *     exclude_numbers=True)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.SecretsManager.GetRandomPassword.Invoke(new()
     *     {
     *         PasswordLength = 50,
     *         ExcludeNumbers = true,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := secretsmanager.GetRandomPassword(ctx, &secretsmanager.GetRandomPasswordArgs{
     * 			PasswordLength: pulumi.IntRef(50),
     * 			ExcludeNumbers: pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetRandomPasswordArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = SecretsmanagerFunctions.getRandomPassword(GetRandomPasswordArgs.builder()
     *             .passwordLength(50)
     *             .excludeNumbers(true)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:secretsmanager:getRandomPassword
     *       Arguments:
     *         passwordLength: 50
     *         excludeNumbers: true
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRandomPassword.
     * @return A collection of values returned by getRandomPassword.
     */
    public suspend fun getRandomPassword(argument: GetRandomPasswordPlainArgs): GetRandomPasswordResult =
        getRandomPasswordResultToKotlin(getRandomPasswordPlain(argument.toJava()).await())

    /**
     * @see [getRandomPassword].
     * @param excludeCharacters String of the characters that you don't want in the password.
     * @param excludeLowercase Specifies whether to exclude lowercase letters from the password.
     * @param excludeNumbers Specifies whether to exclude numbers from the password.
     * @param excludePunctuation Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \ ] ^ _ ` { | } ~ .``
     * @param excludeUppercase Specifies whether to exclude uppercase letters from the password.
     * @param includeSpace Specifies whether to include the space character.
     * @param passwordLength Length of the password.
     * @param requireEachIncludedType Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation.
     * @return A collection of values returned by getRandomPassword.
     */
    public suspend fun getRandomPassword(
        excludeCharacters: String? = null,
        excludeLowercase: Boolean? = null,
        excludeNumbers: Boolean? = null,
        excludePunctuation: Boolean? = null,
        excludeUppercase: Boolean? = null,
        includeSpace: Boolean? = null,
        passwordLength: Int? = null,
        requireEachIncludedType: Boolean? = null,
    ): GetRandomPasswordResult {
        val argument = GetRandomPasswordPlainArgs(
            excludeCharacters = excludeCharacters,
            excludeLowercase = excludeLowercase,
            excludeNumbers = excludeNumbers,
            excludePunctuation = excludePunctuation,
            excludeUppercase = excludeUppercase,
            includeSpace = includeSpace,
            passwordLength = passwordLength,
            requireEachIncludedType = requireEachIncludedType,
        )
        return getRandomPasswordResultToKotlin(getRandomPasswordPlain(argument.toJava()).await())
    }

    /**
     * @see [getRandomPassword].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetRandomPasswordPlainArgs].
     * @return A collection of values returned by getRandomPassword.
     */
    public suspend fun getRandomPassword(argument: suspend GetRandomPasswordPlainArgsBuilder.() -> Unit): GetRandomPasswordResult {
        val builder = GetRandomPasswordPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRandomPasswordResultToKotlin(getRandomPasswordPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve metadata information about a Secrets Manager secret. To retrieve a secret value, see the `aws.secretsmanager.SecretVersion` data source.
     * ## Example Usage
     * ### ARN
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const by-arn = aws.secretsmanager.getSecret({
     *     arn: "arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * by_arn = aws.secretsmanager.get_secret(arn="arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var by_arn = Aws.SecretsManager.GetSecret.Invoke(new()
     *     {
     *         Arn = "arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := secretsmanager.LookupSecret(ctx, &secretsmanager.LookupSecretArgs{
     * 			Arn: pulumi.StringRef("arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var by-arn = SecretsmanagerFunctions.getSecret(GetSecretArgs.builder()
     *             .arn("arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   by-arn:
     *     fn::invoke:
     *       Function: aws:secretsmanager:getSecret
     *       Arguments:
     *         arn: arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Name
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const by-name = aws.secretsmanager.getSecret({
     *     name: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * by_name = aws.secretsmanager.get_secret(name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var by_name = Aws.SecretsManager.GetSecret.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := secretsmanager.LookupSecret(ctx, &secretsmanager.LookupSecretArgs{
     * 			Name: pulumi.StringRef("example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var by-name = SecretsmanagerFunctions.getSecret(GetSecretArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   by-name:
     *     fn::invoke:
     *       Function: aws:secretsmanager:getSecret
     *       Arguments:
     *         name: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecret.
     * @return A collection of values returned by getSecret.
     */
    public suspend fun getSecret(argument: GetSecretPlainArgs): GetSecretResult =
        getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())

    /**
     * @see [getSecret].
     * @param arn ARN of the secret to retrieve.
     * @param name Name of the secret to retrieve.
     * @param tags Tags of the secret.
     * @return A collection of values returned by getSecret.
     */
    public suspend fun getSecret(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetSecretResult {
        val argument = GetSecretPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecret].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetSecretPlainArgs].
     * @return A collection of values returned by getSecret.
     */
    public suspend fun getSecret(argument: suspend GetSecretPlainArgsBuilder.() -> Unit): GetSecretResult {
        val builder = GetSecretPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretResultToKotlin(getSecretPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Secrets Manager secret rotation. To retrieve secret metadata, see the `aws.secretsmanager.Secret` data source. To retrieve a secret value, see the `aws.secretsmanager.SecretVersion` data source.
     * ## Example Usage
     * ### Retrieve Secret Rotation Configuration
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.secretsmanager.getSecretRotation({
     *     secretId: exampleAwsSecretsmanagerSecret.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.secretsmanager.get_secret_rotation(secret_id=example_aws_secretsmanager_secret["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SecretsManager.GetSecretRotation.Invoke(new()
     *     {
     *         SecretId = exampleAwsSecretsmanagerSecret.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := secretsmanager.LookupSecretRotation(ctx, &secretsmanager.LookupSecretRotationArgs{
     * 			SecretId: exampleAwsSecretsmanagerSecret.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretRotationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SecretsmanagerFunctions.getSecretRotation(GetSecretRotationArgs.builder()
     *             .secretId(exampleAwsSecretsmanagerSecret.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:secretsmanager:getSecretRotation
     *       Arguments:
     *         secretId: ${exampleAwsSecretsmanagerSecret.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecretRotation.
     * @return A collection of values returned by getSecretRotation.
     */
    public suspend fun getSecretRotation(argument: GetSecretRotationPlainArgs): GetSecretRotationResult =
        getSecretRotationResultToKotlin(getSecretRotationPlain(argument.toJava()).await())

    /**
     * @see [getSecretRotation].
     * @param secretId Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
     * @return A collection of values returned by getSecretRotation.
     */
    public suspend fun getSecretRotation(secretId: String): GetSecretRotationResult {
        val argument = GetSecretRotationPlainArgs(
            secretId = secretId,
        )
        return getSecretRotationResultToKotlin(getSecretRotationPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecretRotation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetSecretRotationPlainArgs].
     * @return A collection of values returned by getSecretRotation.
     */
    public suspend fun getSecretRotation(argument: suspend GetSecretRotationPlainArgsBuilder.() -> Unit): GetSecretRotationResult {
        val builder = GetSecretRotationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretRotationResultToKotlin(getSecretRotationPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Secrets Manager secret version, including its secret value. To retrieve secret metadata, see the `aws.secretsmanager.Secret` data source.
     * ## Example Usage
     * ### Retrieve Current Secret Version
     * By default, this data sources retrieves information based on the `AWSCURRENT` staging label.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const secret-version = aws.secretsmanager.getSecretVersion({
     *     secretId: example.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * secret_version = aws.secretsmanager.get_secret_version(secret_id=example["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var secret_version = Aws.SecretsManager.GetSecretVersion.Invoke(new()
     *     {
     *         SecretId = example.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := secretsmanager.LookupSecretVersion(ctx, &secretsmanager.LookupSecretVersionArgs{
     * 			SecretId: example.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var secret-version = SecretsmanagerFunctions.getSecretVersion(GetSecretVersionArgs.builder()
     *             .secretId(example.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   secret-version:
     *     fn::invoke:
     *       Function: aws:secretsmanager:getSecretVersion
     *       Arguments:
     *         secretId: ${example.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Retrieve Specific Secret Version
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const by-version-stage = aws.secretsmanager.getSecretVersion({
     *     secretId: example.id,
     *     versionStage: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * by_version_stage = aws.secretsmanager.get_secret_version(secret_id=example["id"],
     *     version_stage="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var by_version_stage = Aws.SecretsManager.GetSecretVersion.Invoke(new()
     *     {
     *         SecretId = example.Id,
     *         VersionStage = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := secretsmanager.LookupSecretVersion(ctx, &secretsmanager.LookupSecretVersionArgs{
     * 			SecretId:     example.Id,
     * 			VersionStage: pulumi.StringRef("example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var by-version-stage = SecretsmanagerFunctions.getSecretVersion(GetSecretVersionArgs.builder()
     *             .secretId(example.id())
     *             .versionStage("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   by-version-stage:
     *     fn::invoke:
     *       Function: aws:secretsmanager:getSecretVersion
     *       Arguments:
     *         secretId: ${example.id}
     *         versionStage: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecretVersion.
     * @return A collection of values returned by getSecretVersion.
     */
    public suspend fun getSecretVersion(argument: GetSecretVersionPlainArgs): GetSecretVersionResult =
        getSecretVersionResultToKotlin(getSecretVersionPlain(argument.toJava()).await())

    /**
     * @see [getSecretVersion].
     * @param secretId Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
     * @param versionId Specifies the unique identifier of the version of the secret that you want to retrieve. Overrides `version_stage`.
     * @param versionStage Specifies the secret version that you want to retrieve by the staging label attached to the version. Defaults to `AWSCURRENT`.
     * @return A collection of values returned by getSecretVersion.
     */
    public suspend fun getSecretVersion(
        secretId: String,
        versionId: String? = null,
        versionStage: String? = null,
    ): GetSecretVersionResult {
        val argument = GetSecretVersionPlainArgs(
            secretId = secretId,
            versionId = versionId,
            versionStage = versionStage,
        )
        return getSecretVersionResultToKotlin(getSecretVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecretVersion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetSecretVersionPlainArgs].
     * @return A collection of values returned by getSecretVersion.
     */
    public suspend fun getSecretVersion(argument: suspend GetSecretVersionPlainArgsBuilder.() -> Unit): GetSecretVersionResult {
        val builder = GetSecretVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretVersionResultToKotlin(getSecretVersionPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getSecretVersions.
     * @return A collection of values returned by getSecretVersions.
     */
    public suspend fun getSecretVersions(argument: GetSecretVersionsPlainArgs): GetSecretVersionsResult =
        getSecretVersionsResultToKotlin(getSecretVersionsPlain(argument.toJava()).await())

    /**
     * @see [getSecretVersions].
     * @param includeDeprecated If true, all deprecated secret versions are included in the response.
     * If false, no deprecated secret versions are included in the response. If no value is specified, the default value is `false`.
     * @param secretId Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
     * @return A collection of values returned by getSecretVersions.
     */
    public suspend fun getSecretVersions(includeDeprecated: Boolean? = null, secretId: String): GetSecretVersionsResult {
        val argument = GetSecretVersionsPlainArgs(
            includeDeprecated = includeDeprecated,
            secretId = secretId,
        )
        return getSecretVersionsResultToKotlin(getSecretVersionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecretVersions].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetSecretVersionsPlainArgs].
     * @return A collection of values returned by getSecretVersions.
     */
    public suspend fun getSecretVersions(argument: suspend GetSecretVersionsPlainArgsBuilder.() -> Unit): GetSecretVersionsResult {
        val builder = GetSecretVersionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretVersionsResultToKotlin(getSecretVersionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and names of Secrets Manager secrets matching the specified criteria.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.secretsmanager.getSecrets({
     *     filters: [{
     *         name: "name",
     *         values: ["example"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.secretsmanager.get_secrets(filters=[{
     *     "name": "name",
     *     "values": ["example"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SecretsManager.GetSecrets.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.SecretsManager.Inputs.GetSecretsFilterInputArgs
     *             {
     *                 Name = "name",
     *                 Values = new[]
     *                 {
     *                     "example",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/secretsmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := secretsmanager.GetSecrets(ctx, &secretsmanager.GetSecretsArgs{
     * 			Filters: []secretsmanager.GetSecretsFilter{
     * 				{
     * 					Name: "name",
     * 					Values: []string{
     * 						"example",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SecretsmanagerFunctions.getSecrets(GetSecretsArgs.builder()
     *             .filters(GetSecretsFilterArgs.builder()
     *                 .name("name")
     *                 .values("example")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:secretsmanager:getSecrets
     *       Arguments:
     *         filters:
     *           - name: name
     *             values:
     *               - example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecrets.
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(argument: GetSecretsPlainArgs): GetSecretsResult =
        getSecretsResultToKotlin(getSecretsPlain(argument.toJava()).await())

    /**
     * @see [getSecrets].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(filters: List<GetSecretsFilter>? = null): GetSecretsResult {
        val argument = GetSecretsPlainArgs(
            filters = filters,
        )
        return getSecretsResultToKotlin(getSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetSecretsPlainArgs].
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(argument: suspend GetSecretsPlainArgsBuilder.() -> Unit): GetSecretsResult {
        val builder = GetSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretsResultToKotlin(getSecretsPlain(builtArgument.toJava()).await())
    }
}
