@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.inputs

import com.pulumi.aws.secretsmanager.inputs.GetSecretRotationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecretRotation.
 * @property secretId Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
 */
public data class GetSecretRotationPlainArgs(
    public val secretId: String,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.inputs.GetSecretRotationPlainArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.inputs.GetSecretRotationPlainArgs =
        com.pulumi.aws.secretsmanager.inputs.GetSecretRotationPlainArgs.builder()
            .secretId(secretId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecretRotationPlainArgs].
 */
@PulumiTagMarker
public class GetSecretRotationPlainArgsBuilder internal constructor() {
    private var secretId: String? = null

    /**
     * @param value Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
     */
    @JvmName("ileevxtiqkhbfisj")
    public suspend fun secretId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secretId = mapped
    }

    internal fun build(): GetSecretRotationPlainArgs = GetSecretRotationPlainArgs(
        secretId = secretId ?: throw PulumiNullFieldException("secretId"),
    )
}
