@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.inputs

import com.pulumi.aws.secretsmanager.inputs.GetSecretVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecretVersion.
 * @property secretId Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
 * @property versionId Specifies the unique identifier of the version of the secret that you want to retrieve. Overrides `version_stage`.
 * @property versionStage Specifies the secret version that you want to retrieve by the staging label attached to the version. Defaults to `AWSCURRENT`.
 */
public data class GetSecretVersionPlainArgs(
    public val secretId: String,
    public val versionId: String? = null,
    public val versionStage: String? = null,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.inputs.GetSecretVersionPlainArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.inputs.GetSecretVersionPlainArgs =
        com.pulumi.aws.secretsmanager.inputs.GetSecretVersionPlainArgs.builder()
            .secretId(secretId.let({ args0 -> args0 }))
            .versionId(versionId?.let({ args0 -> args0 }))
            .versionStage(versionStage?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecretVersionPlainArgs].
 */
@PulumiTagMarker
public class GetSecretVersionPlainArgsBuilder internal constructor() {
    private var secretId: String? = null

    private var versionId: String? = null

    private var versionStage: String? = null

    /**
     * @param value Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
     */
    @JvmName("wefjyfgslovickeg")
    public suspend fun secretId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secretId = mapped
    }

    /**
     * @param value Specifies the unique identifier of the version of the secret that you want to retrieve. Overrides `version_stage`.
     */
    @JvmName("uwdasuexoysrkhqj")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.versionId = mapped
    }

    /**
     * @param value Specifies the secret version that you want to retrieve by the staging label attached to the version. Defaults to `AWSCURRENT`.
     */
    @JvmName("fqgpqngiukakpscn")
    public suspend fun versionStage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.versionStage = mapped
    }

    internal fun build(): GetSecretVersionPlainArgs = GetSecretVersionPlainArgs(
        secretId = secretId ?: throw PulumiNullFieldException("secretId"),
        versionId = versionId,
        versionStage = versionStage,
    )
}
