@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.inputs

import com.pulumi.aws.secretsmanager.inputs.GetSecretVersionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecretVersions.
 * @property includeDeprecated If true, all deprecated secret versions are included in the response.
 * If false, no deprecated secret versions are included in the response. If no value is specified, the default value is `false`.
 * @property secretId Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
 */
public data class GetSecretVersionsPlainArgs(
    public val includeDeprecated: Boolean? = null,
    public val secretId: String,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.inputs.GetSecretVersionsPlainArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.inputs.GetSecretVersionsPlainArgs =
        com.pulumi.aws.secretsmanager.inputs.GetSecretVersionsPlainArgs.builder()
            .includeDeprecated(includeDeprecated?.let({ args0 -> args0 }))
            .secretId(secretId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecretVersionsPlainArgs].
 */
@PulumiTagMarker
public class GetSecretVersionsPlainArgsBuilder internal constructor() {
    private var includeDeprecated: Boolean? = null

    private var secretId: String? = null

    /**
     * @param value If true, all deprecated secret versions are included in the response.
     * If false, no deprecated secret versions are included in the response. If no value is specified, the default value is `false`.
     */
    @JvmName("tvlutjpqncnbkoro")
    public suspend fun includeDeprecated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeDeprecated = mapped
    }

    /**
     * @param value Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
     */
    @JvmName("aggcfyvuwylajswu")
    public suspend fun secretId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secretId = mapped
    }

    internal fun build(): GetSecretVersionsPlainArgs = GetSecretVersionsPlainArgs(
        includeDeprecated = includeDeprecated,
        secretId = secretId ?: throw PulumiNullFieldException("secretId"),
    )
}
