@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.inputs

import com.pulumi.aws.secretsmanager.inputs.GetSecretsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecrets.
 * @property filters Configuration block(s) for filtering. Detailed below.
 */
public data class GetSecretsPlainArgs(
    public val filters: List<GetSecretsFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.inputs.GetSecretsPlainArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.inputs.GetSecretsPlainArgs =
        com.pulumi.aws.secretsmanager.inputs.GetSecretsPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetSecretsPlainArgs].
 */
@PulumiTagMarker
public class GetSecretsPlainArgsBuilder internal constructor() {
    private var filters: List<GetSecretsFilter>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("fnbwssifjywgohbb")
    public suspend fun filters(`value`: List<GetSecretsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("nyrcjumerghmbugj")
    public suspend fun filters(argument: List<suspend GetSecretsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSecretsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ucdcrihdlhngwmkx")
    public suspend fun filters(vararg argument: suspend GetSecretsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSecretsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ertpyywashobssxr")
    public suspend fun filters(argument: suspend GetSecretsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSecretsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ajbrqthumlsqahma")
    public suspend fun filters(vararg values: GetSecretsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetSecretsPlainArgs = GetSecretsPlainArgs(
        filters = filters,
    )
}
