@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getRandomPassword.
 * @property excludeCharacters
 * @property excludeLowercase
 * @property excludeNumbers
 * @property excludePunctuation
 * @property excludeUppercase
 * @property id The provider-assigned unique ID for this managed resource.
 * @property includeSpace
 * @property passwordLength
 * @property randomPassword Random password.
 * @property requireEachIncludedType
 */
public data class GetRandomPasswordResult(
    public val excludeCharacters: String? = null,
    public val excludeLowercase: Boolean? = null,
    public val excludeNumbers: Boolean? = null,
    public val excludePunctuation: Boolean? = null,
    public val excludeUppercase: Boolean? = null,
    public val id: String,
    public val includeSpace: Boolean? = null,
    public val passwordLength: Int? = null,
    public val randomPassword: String,
    public val requireEachIncludedType: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.secretsmanager.outputs.GetRandomPasswordResult): GetRandomPasswordResult = GetRandomPasswordResult(
            excludeCharacters = javaType.excludeCharacters().map({ args0 -> args0 }).orElse(null),
            excludeLowercase = javaType.excludeLowercase().map({ args0 -> args0 }).orElse(null),
            excludeNumbers = javaType.excludeNumbers().map({ args0 -> args0 }).orElse(null),
            excludePunctuation = javaType.excludePunctuation().map({ args0 -> args0 }).orElse(null),
            excludeUppercase = javaType.excludeUppercase().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            includeSpace = javaType.includeSpace().map({ args0 -> args0 }).orElse(null),
            passwordLength = javaType.passwordLength().map({ args0 -> args0 }).orElse(null),
            randomPassword = javaType.randomPassword(),
            requireEachIncludedType = javaType.requireEachIncludedType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
