@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getSecret.
 * @property arn ARN of the secret.
 * @property createdDate Created date of the secret in UTC.
 * @property description Description of the secret.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId Key Management Service (KMS) Customer Master Key (CMK) associated with the secret.
 * @property lastChangedDate Last updated date of the secret in UTC.
 * @property name
 * @property policy Resource-based policy document that's attached to the secret.
 * @property tags Tags of the secret.
 */
public data class GetSecretResult(
    public val arn: String,
    public val createdDate: String,
    public val description: String,
    public val id: String,
    public val kmsKeyId: String,
    public val lastChangedDate: String,
    public val name: String,
    public val policy: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.secretsmanager.outputs.GetSecretResult): GetSecretResult = GetSecretResult(
            arn = javaType.arn(),
            createdDate = javaType.createdDate(),
            description = javaType.description(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            lastChangedDate = javaType.lastChangedDate(),
            name = javaType.name(),
            policy = javaType.policy(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
