@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSecretVersion.
 * @property arn ARN of the secret.
 * @property createdDate Created date of the secret in UTC.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property secretBinary Decrypted part of the protected secret information that was originally provided as a binary.
 * @property secretId
 * @property secretString Decrypted part of the protected secret information that was originally provided as a string.
 * @property versionId Unique identifier of this version of the secret.
 * @property versionStage
 * @property versionStages
 */
public data class GetSecretVersionResult(
    public val arn: String,
    public val createdDate: String,
    public val id: String,
    public val secretBinary: String,
    public val secretId: String,
    public val secretString: String,
    public val versionId: String,
    public val versionStage: String? = null,
    public val versionStages: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.secretsmanager.outputs.GetSecretVersionResult): GetSecretVersionResult = GetSecretVersionResult(
            arn = javaType.arn(),
            createdDate = javaType.createdDate(),
            id = javaType.id(),
            secretBinary = javaType.secretBinary(),
            secretId = javaType.secretId(),
            secretString = javaType.secretString(),
            versionId = javaType.versionId(),
            versionStage = javaType.versionStage().map({ args0 -> args0 }).orElse(null),
            versionStages = javaType.versionStages().map({ args0 -> args0 }),
        )
    }
}
