@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSecretVersions.
 * @property arn ARN of the secret.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property includeDeprecated
 * @property name
 * @property secretId
 * @property versions List of the versions of the secret. Attributes are specified below.
 */
public data class GetSecretVersionsResult(
    public val arn: String,
    public val id: String,
    public val includeDeprecated: Boolean? = null,
    public val name: String,
    public val secretId: String,
    public val versions: List<GetSecretVersionsVersion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.secretsmanager.outputs.GetSecretVersionsResult): GetSecretVersionsResult = GetSecretVersionsResult(
            arn = javaType.arn(),
            id = javaType.id(),
            includeDeprecated = javaType.includeDeprecated().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            secretId = javaType.secretId(),
            versions = javaType.versions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretVersionsVersion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
