@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createdTime
 * @property lastAccessedDate Date that this version of the secret was last accessed.
 * @property versionId Unique version identifier of this version of the secret.
 * @property versionStages
 */
public data class GetSecretVersionsVersion(
    public val createdTime: String,
    public val lastAccessedDate: String,
    public val versionId: String,
    public val versionStages: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.secretsmanager.outputs.GetSecretVersionsVersion): GetSecretVersionsVersion = GetSecretVersionsVersion(
            createdTime = javaType.createdTime(),
            lastAccessedDate = javaType.lastAccessedDate(),
            versionId = javaType.versionId(),
            versionStages = javaType.versionStages().map({ args0 -> args0 }),
        )
    }
}
