@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.AccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Enables Security Hub for this AWS account.
 * > **NOTE:** Destroying this resource will disable Security Hub for this AWS account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an existing Security Hub enabled account using the AWS account ID. For example:
 * ```sh
 * $ pulumi import aws:securityhub/account:Account example 123456789012
 * ```
 * @property autoEnableControls Whether to automatically enable new controls when they are added to standards that are enabled. By default, this is set to true, and new controls are enabled automatically. To not automatically enable new controls, set this to false.
 * @property controlFindingGenerator Updates whether the calling account has consolidated control findings turned on. If the value for this field is set to `SECURITY_CONTROL`, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards. If the value for this field is set to `STANDARD_CONTROL`, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards. For accounts that are part of an organization, this value can only be updated in the administrator account.
 * @property enableDefaultStandards Whether to enable the security standards that Security Hub has designated as automatically enabled including: ` AWS Foundational Security Best Practices v1.0.0` and `CIS AWS Foundations Benchmark v1.2.0`. Defaults to `true`.
 */
public data class AccountArgs(
    public val autoEnableControls: Output<Boolean>? = null,
    public val controlFindingGenerator: Output<String>? = null,
    public val enableDefaultStandards: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.AccountArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.AccountArgs =
        com.pulumi.aws.securityhub.AccountArgs.builder()
            .autoEnableControls(autoEnableControls?.applyValue({ args0 -> args0 }))
            .controlFindingGenerator(controlFindingGenerator?.applyValue({ args0 -> args0 }))
            .enableDefaultStandards(enableDefaultStandards?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var autoEnableControls: Output<Boolean>? = null

    private var controlFindingGenerator: Output<String>? = null

    private var enableDefaultStandards: Output<Boolean>? = null

    /**
     * @param value Whether to automatically enable new controls when they are added to standards that are enabled. By default, this is set to true, and new controls are enabled automatically. To not automatically enable new controls, set this to false.
     */
    @JvmName("qswasvqarsctjktv")
    public suspend fun autoEnableControls(`value`: Output<Boolean>) {
        this.autoEnableControls = value
    }

    /**
     * @param value Updates whether the calling account has consolidated control findings turned on. If the value for this field is set to `SECURITY_CONTROL`, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards. If the value for this field is set to `STANDARD_CONTROL`, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards. For accounts that are part of an organization, this value can only be updated in the administrator account.
     */
    @JvmName("rksbxiyumiptajxw")
    public suspend fun controlFindingGenerator(`value`: Output<String>) {
        this.controlFindingGenerator = value
    }

    /**
     * @param value Whether to enable the security standards that Security Hub has designated as automatically enabled including: ` AWS Foundational Security Best Practices v1.0.0` and `CIS AWS Foundations Benchmark v1.2.0`. Defaults to `true`.
     */
    @JvmName("xolgdcjdetnfwpam")
    public suspend fun enableDefaultStandards(`value`: Output<Boolean>) {
        this.enableDefaultStandards = value
    }

    /**
     * @param value Whether to automatically enable new controls when they are added to standards that are enabled. By default, this is set to true, and new controls are enabled automatically. To not automatically enable new controls, set this to false.
     */
    @JvmName("guhcuwkfltfnowkk")
    public suspend fun autoEnableControls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoEnableControls = mapped
    }

    /**
     * @param value Updates whether the calling account has consolidated control findings turned on. If the value for this field is set to `SECURITY_CONTROL`, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards. If the value for this field is set to `STANDARD_CONTROL`, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards. For accounts that are part of an organization, this value can only be updated in the administrator account.
     */
    @JvmName("aelgsngauuyplkxj")
    public suspend fun controlFindingGenerator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlFindingGenerator = mapped
    }

    /**
     * @param value Whether to enable the security standards that Security Hub has designated as automatically enabled including: ` AWS Foundational Security Best Practices v1.0.0` and `CIS AWS Foundations Benchmark v1.2.0`. Defaults to `true`.
     */
    @JvmName("hdvkpgtnpcvtmolq")
    public suspend fun enableDefaultStandards(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDefaultStandards = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        autoEnableControls = autoEnableControls,
        controlFindingGenerator = controlFindingGenerator,
        enableDefaultStandards = enableDefaultStandards,
    )
}
