@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ActionTarget].
 */
@PulumiTagMarker
public class ActionTargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActionTargetArgs = ActionTargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActionTargetArgsBuilder.() -> Unit) {
        val builder = ActionTargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ActionTarget {
        val builtJavaResource = com.pulumi.aws.securityhub.ActionTarget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ActionTarget(builtJavaResource)
    }
}

/**
 * Creates Security Hub custom action.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleActionTarget = new aws.securityhub.ActionTarget("example", {
 *     name: "Send notification to chat",
 *     identifier: "SendToChat",
 *     description: "This is custom action sends selected findings to chat",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_action_target = aws.securityhub.ActionTarget("example",
 *     name="Send notification to chat",
 *     identifier="SendToChat",
 *     description="This is custom action sends selected findings to chat",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleActionTarget = new Aws.SecurityHub.ActionTarget("example", new()
 *     {
 *         Name = "Send notification to chat",
 *         Identifier = "SendToChat",
 *         Description = "This is custom action sends selected findings to chat",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewActionTarget(ctx, "example", &securityhub.ActionTargetArgs{
 * 			Name:        pulumi.String("Send notification to chat"),
 * 			Identifier:  pulumi.String("SendToChat"),
 * 			Description: pulumi.String("This is custom action sends selected findings to chat"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.ActionTarget;
 * import com.pulumi.aws.securityhub.ActionTargetArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleActionTarget = new ActionTarget("exampleActionTarget", ActionTargetArgs.builder()
 *             .name("Send notification to chat")
 *             .identifier("SendToChat")
 *             .description("This is custom action sends selected findings to chat")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleActionTarget:
 *     type: aws:securityhub:ActionTarget
 *     name: example
 *     properties:
 *       name: Send notification to chat
 *       identifier: SendToChat
 *       description: This is custom action sends selected findings to chat
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Hub custom action using the action target ARN. For example:
 * ```sh
 * $ pulumi import aws:securityhub/actionTarget:ActionTarget example arn:aws:securityhub:eu-west-1:312940875350:action/custom/a
 * ```
 */
public class ActionTarget internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.ActionTarget,
) : KotlinCustomResource(javaResource, ActionTargetMapper) {
    /**
     * Amazon Resource Name (ARN) of the Security Hub custom action target.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the custom action target.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The ID for the custom action target.
     */
    public val identifier: Output<String>
        get() = javaResource.identifier().applyValue({ args0 -> args0 })

    /**
     * The description for the custom action target.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object ActionTargetMapper : ResourceMapper<ActionTarget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.ActionTarget::class == javaResource::class

    override fun map(javaResource: Resource): ActionTarget = ActionTarget(
        javaResource as
            com.pulumi.aws.securityhub.ActionTarget,
    )
}

/**
 * @see [ActionTarget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ActionTarget].
 */
public suspend fun actionTarget(
    name: String,
    block: suspend ActionTargetResourceBuilder.() -> Unit,
): ActionTarget {
    val builder = ActionTargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ActionTarget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun actionTarget(name: String): ActionTarget {
    val builder = ActionTargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
