@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleAction
import com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteria
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleAction.Companion.toKotlin as automationRuleActionToKotlin
import com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteria.Companion.toKotlin as automationRuleCriteriaToKotlin

/**
 * Builder for [AutomationRule].
 */
@PulumiTagMarker
public class AutomationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutomationRuleArgs = AutomationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutomationRuleArgsBuilder.() -> Unit) {
        val builder = AutomationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AutomationRule {
        val builtJavaResource = com.pulumi.aws.securityhub.AutomationRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AutomationRule(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Security Hub Automation Rule.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.AutomationRule("example", {
 *     description: "Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk",
 *     ruleName: "Elevate severity of findings that relate to important resources",
 *     ruleOrder: 1,
 *     actions: [{
 *         findingFieldsUpdate: {
 *             severity: {
 *                 label: "CRITICAL",
 *                 product: 0,
 *             },
 *             note: {
 *                 text: "This is a critical resource. Please review ASAP.",
 *                 updatedBy: "sechub-automation",
 *             },
 *             types: ["Software and Configuration Checks/Industry and Regulatory Standards"],
 *             userDefinedFields: {
 *                 key: "value",
 *             },
 *         },
 *         type: "FINDING_FIELDS_UPDATE",
 *     }],
 *     criteria: {
 *         resourceIds: [{
 *             comparison: "EQUALS",
 *             value: "arn:aws:s3:::examplebucket/*",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.AutomationRule("example",
 *     description="Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk",
 *     rule_name="Elevate severity of findings that relate to important resources",
 *     rule_order=1,
 *     actions=[{
 *         "finding_fields_update": {
 *             "severity": {
 *                 "label": "CRITICAL",
 *                 "product": 0,
 *             },
 *             "note": {
 *                 "text": "This is a critical resource. Please review ASAP.",
 *                 "updated_by": "sechub-automation",
 *             },
 *             "types": ["Software and Configuration Checks/Industry and Regulatory Standards"],
 *             "user_defined_fields": {
 *                 "key": "value",
 *             },
 *         },
 *         "type": "FINDING_FIELDS_UPDATE",
 *     }],
 *     criteria={
 *         "resource_ids": [{
 *             "comparison": "EQUALS",
 *             "value": "arn:aws:s3:::examplebucket/*",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.AutomationRule("example", new()
 *     {
 *         Description = "Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk",
 *         RuleName = "Elevate severity of findings that relate to important resources",
 *         RuleOrder = 1,
 *         Actions = new[]
 *         {
 *             new Aws.SecurityHub.Inputs.AutomationRuleActionArgs
 *             {
 *                 FindingFieldsUpdate = new Aws.SecurityHub.Inputs.AutomationRuleActionFindingFieldsUpdateArgs
 *                 {
 *                     Severity = new Aws.SecurityHub.Inputs.AutomationRuleActionFindingFieldsUpdateSeverityArgs
 *                     {
 *                         Label = "CRITICAL",
 *                         Product = 0,
 *                     },
 *                     Note = new Aws.SecurityHub.Inputs.AutomationRuleActionFindingFieldsUpdateNoteArgs
 *                     {
 *                         Text = "This is a critical resource. Please review ASAP.",
 *                         UpdatedBy = "sechub-automation",
 *                     },
 *                     Types = new[]
 *                     {
 *                         "Software and Configuration Checks/Industry and Regulatory Standards",
 *                     },
 *                     UserDefinedFields =
 *                     {
 *                         { "key", "value" },
 *                     },
 *                 },
 *                 Type = "FINDING_FIELDS_UPDATE",
 *             },
 *         },
 *         Criteria = new Aws.SecurityHub.Inputs.AutomationRuleCriteriaArgs
 *         {
 *             ResourceIds = new[]
 *             {
 *                 new Aws.SecurityHub.Inputs.AutomationRuleCriteriaResourceIdArgs
 *                 {
 *                     Comparison = "EQUALS",
 *                     Value = "arn:aws:s3:::examplebucket/*",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityhub.NewAutomationRule(ctx, "example", &securityhub.AutomationRuleArgs{
 * 			Description: pulumi.String("Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk"),
 * 			RuleName:    pulumi.String("Elevate severity of findings that relate to important resources"),
 * 			RuleOrder:   pulumi.Int(1),
 * 			Actions: securityhub.AutomationRuleActionArray{
 * 				&securityhub.AutomationRuleActionArgs{
 * 					FindingFieldsUpdate: &securityhub.AutomationRuleActionFindingFieldsUpdateArgs{
 * 						Severity: &securityhub.AutomationRuleActionFindingFieldsUpdateSeverityArgs{
 * 							Label:   pulumi.String("CRITICAL"),
 * 							Product: pulumi.Float64(0),
 * 						},
 * 						Note: &securityhub.AutomationRuleActionFindingFieldsUpdateNoteArgs{
 * 							Text:      pulumi.String("This is a critical resource. Please review ASAP."),
 * 							UpdatedBy: pulumi.String("sechub-automation"),
 * 						},
 * 						Types: pulumi.StringArray{
 * 							pulumi.String("Software and Configuration Checks/Industry and Regulatory Standards"),
 * 						},
 * 						UserDefinedFields: pulumi.StringMap{
 * 							"key": pulumi.String("value"),
 * 						},
 * 					},
 * 					Type: pulumi.String("FINDING_FIELDS_UPDATE"),
 * 				},
 * 			},
 * 			Criteria: &securityhub.AutomationRuleCriteriaArgs{
 * 				ResourceIds: securityhub.AutomationRuleCriteriaResourceIdArray{
 * 					&securityhub.AutomationRuleCriteriaResourceIdArgs{
 * 						Comparison: pulumi.String("EQUALS"),
 * 						Value:      pulumi.String("arn:aws:s3:::examplebucket/*"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.AutomationRule;
 * import com.pulumi.aws.securityhub.AutomationRuleArgs;
 * import com.pulumi.aws.securityhub.inputs.AutomationRuleActionArgs;
 * import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateArgs;
 * import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateSeverityArgs;
 * import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateNoteArgs;
 * import com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AutomationRule("example", AutomationRuleArgs.builder()
 *             .description("Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk")
 *             .ruleName("Elevate severity of findings that relate to important resources")
 *             .ruleOrder(1)
 *             .actions(AutomationRuleActionArgs.builder()
 *                 .findingFieldsUpdate(AutomationRuleActionFindingFieldsUpdateArgs.builder()
 *                     .severity(AutomationRuleActionFindingFieldsUpdateSeverityArgs.builder()
 *                         .label("CRITICAL")
 *                         .product("0.0")
 *                         .build())
 *                     .note(AutomationRuleActionFindingFieldsUpdateNoteArgs.builder()
 *                         .text("This is a critical resource. Please review ASAP.")
 *                         .updatedBy("sechub-automation")
 *                         .build())
 *                     .types("Software and Configuration Checks/Industry and Regulatory Standards")
 *                     .userDefinedFields(Map.of("key", "value"))
 *                     .build())
 *                 .type("FINDING_FIELDS_UPDATE")
 *                 .build())
 *             .criteria(AutomationRuleCriteriaArgs.builder()
 *                 .resourceIds(AutomationRuleCriteriaResourceIdArgs.builder()
 *                     .comparison("EQUALS")
 *                     .value("arn:aws:s3:::examplebucket/*")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:AutomationRule
 *     properties:
 *       description: Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk
 *       ruleName: Elevate severity of findings that relate to important resources
 *       ruleOrder: 1
 *       actions:
 *         - findingFieldsUpdate:
 *             severity:
 *               label: CRITICAL
 *               product: '0.0'
 *             note:
 *               text: This is a critical resource. Please review ASAP.
 *               updatedBy: sechub-automation
 *             types:
 *               - Software and Configuration Checks/Industry and Regulatory Standards
 *             userDefinedFields:
 *               key: value
 *           type: FINDING_FIELDS_UPDATE
 *       criteria:
 *         resourceIds:
 *           - comparison: EQUALS
 *             value: arn:aws:s3:::examplebucket/*
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Hub automation rule using their ARN. For example:
 * ```sh
 * $ pulumi import aws:securityhub/automationRule:AutomationRule example arn:aws:securityhub:us-west-2:123456789012:automation-rule/473eddde-f5c4-4ae5-85c7-e922f271fffc
 * ```
 * */*/*/*/*/*/
 */
public class AutomationRule internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.AutomationRule,
) : KotlinCustomResource(javaResource, AutomationRuleMapper) {
    /**
     * A block that specifies one or more actions to update finding fields if a finding matches the conditions specified in `Criteria`. Documented below.
     */
    public val actions: Output<List<AutomationRuleAction>>?
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> automationRuleActionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The ARN of the Security Hub automation rule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A block that specifies a set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter findings. Documented below.
     */
    public val criteria: Output<AutomationRuleCriteria>?
        get() = javaResource.criteria().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    automationRuleCriteriaToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The description of the rule.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. Defaults to `false`.
     */
    public val isTerminal: Output<Boolean>
        get() = javaResource.isTerminal().applyValue({ args0 -> args0 })

    /**
     * The name of the rule.
     */
    public val ruleName: Output<String>
        get() = javaResource.ruleName().applyValue({ args0 -> args0 })

    /**
     * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
     */
    public val ruleOrder: Output<Int>
        get() = javaResource.ruleOrder().applyValue({ args0 -> args0 })

    /**
     * Whether the rule is active after it is created.
     */
    public val ruleStatus: Output<String>
        get() = javaResource.ruleStatus().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AutomationRuleMapper : ResourceMapper<AutomationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.AutomationRule::class == javaResource::class

    override fun map(javaResource: Resource): AutomationRule = AutomationRule(
        javaResource as
            com.pulumi.aws.securityhub.AutomationRule,
    )
}

/**
 * @see [AutomationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutomationRule].
 */
public suspend fun automationRule(
    name: String,
    block: suspend AutomationRuleResourceBuilder.() -> Unit,
): AutomationRule {
    val builder = AutomationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutomationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun automationRule(name: String): AutomationRule {
    val builder = AutomationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
