@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.AutomationRuleArgs.builder
import com.pulumi.aws.securityhub.kotlin.inputs.AutomationRuleActionArgs
import com.pulumi.aws.securityhub.kotlin.inputs.AutomationRuleActionArgsBuilder
import com.pulumi.aws.securityhub.kotlin.inputs.AutomationRuleCriteriaArgs
import com.pulumi.aws.securityhub.kotlin.inputs.AutomationRuleCriteriaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Security Hub Automation Rule.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.AutomationRule("example", {
 *     description: "Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk",
 *     ruleName: "Elevate severity of findings that relate to important resources",
 *     ruleOrder: 1,
 *     actions: [{
 *         findingFieldsUpdate: {
 *             severity: {
 *                 label: "CRITICAL",
 *                 product: 0,
 *             },
 *             note: {
 *                 text: "This is a critical resource. Please review ASAP.",
 *                 updatedBy: "sechub-automation",
 *             },
 *             types: ["Software and Configuration Checks/Industry and Regulatory Standards"],
 *             userDefinedFields: {
 *                 key: "value",
 *             },
 *         },
 *         type: "FINDING_FIELDS_UPDATE",
 *     }],
 *     criteria: {
 *         resourceIds: [{
 *             comparison: "EQUALS",
 *             value: "arn:aws:s3:::examplebucket/*",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.AutomationRule("example",
 *     description="Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk",
 *     rule_name="Elevate severity of findings that relate to important resources",
 *     rule_order=1,
 *     actions=[{
 *         "finding_fields_update": {
 *             "severity": {
 *                 "label": "CRITICAL",
 *                 "product": 0,
 *             },
 *             "note": {
 *                 "text": "This is a critical resource. Please review ASAP.",
 *                 "updated_by": "sechub-automation",
 *             },
 *             "types": ["Software and Configuration Checks/Industry and Regulatory Standards"],
 *             "user_defined_fields": {
 *                 "key": "value",
 *             },
 *         },
 *         "type": "FINDING_FIELDS_UPDATE",
 *     }],
 *     criteria={
 *         "resource_ids": [{
 *             "comparison": "EQUALS",
 *             "value": "arn:aws:s3:::examplebucket/*",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.AutomationRule("example", new()
 *     {
 *         Description = "Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk",
 *         RuleName = "Elevate severity of findings that relate to important resources",
 *         RuleOrder = 1,
 *         Actions = new[]
 *         {
 *             new Aws.SecurityHub.Inputs.AutomationRuleActionArgs
 *             {
 *                 FindingFieldsUpdate = new Aws.SecurityHub.Inputs.AutomationRuleActionFindingFieldsUpdateArgs
 *                 {
 *                     Severity = new Aws.SecurityHub.Inputs.AutomationRuleActionFindingFieldsUpdateSeverityArgs
 *                     {
 *                         Label = "CRITICAL",
 *                         Product = 0,
 *                     },
 *                     Note = new Aws.SecurityHub.Inputs.AutomationRuleActionFindingFieldsUpdateNoteArgs
 *                     {
 *                         Text = "This is a critical resource. Please review ASAP.",
 *                         UpdatedBy = "sechub-automation",
 *                     },
 *                     Types = new[]
 *                     {
 *                         "Software and Configuration Checks/Industry and Regulatory Standards",
 *                     },
 *                     UserDefinedFields =
 *                     {
 *                         { "key", "value" },
 *                     },
 *                 },
 *                 Type = "FINDING_FIELDS_UPDATE",
 *             },
 *         },
 *         Criteria = new Aws.SecurityHub.Inputs.AutomationRuleCriteriaArgs
 *         {
 *             ResourceIds = new[]
 *             {
 *                 new Aws.SecurityHub.Inputs.AutomationRuleCriteriaResourceIdArgs
 *                 {
 *                     Comparison = "EQUALS",
 *                     Value = "arn:aws:s3:::examplebucket/*",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityhub.NewAutomationRule(ctx, "example", &securityhub.AutomationRuleArgs{
 * 			Description: pulumi.String("Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk"),
 * 			RuleName:    pulumi.String("Elevate severity of findings that relate to important resources"),
 * 			RuleOrder:   pulumi.Int(1),
 * 			Actions: securityhub.AutomationRuleActionArray{
 * 				&securityhub.AutomationRuleActionArgs{
 * 					FindingFieldsUpdate: &securityhub.AutomationRuleActionFindingFieldsUpdateArgs{
 * 						Severity: &securityhub.AutomationRuleActionFindingFieldsUpdateSeverityArgs{
 * 							Label:   pulumi.String("CRITICAL"),
 * 							Product: pulumi.Float64(0),
 * 						},
 * 						Note: &securityhub.AutomationRuleActionFindingFieldsUpdateNoteArgs{
 * 							Text:      pulumi.String("This is a critical resource. Please review ASAP."),
 * 							UpdatedBy: pulumi.String("sechub-automation"),
 * 						},
 * 						Types: pulumi.StringArray{
 * 							pulumi.String("Software and Configuration Checks/Industry and Regulatory Standards"),
 * 						},
 * 						UserDefinedFields: pulumi.StringMap{
 * 							"key": pulumi.String("value"),
 * 						},
 * 					},
 * 					Type: pulumi.String("FINDING_FIELDS_UPDATE"),
 * 				},
 * 			},
 * 			Criteria: &securityhub.AutomationRuleCriteriaArgs{
 * 				ResourceIds: securityhub.AutomationRuleCriteriaResourceIdArray{
 * 					&securityhub.AutomationRuleCriteriaResourceIdArgs{
 * 						Comparison: pulumi.String("EQUALS"),
 * 						Value:      pulumi.String("arn:aws:s3:::examplebucket/*"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.AutomationRule;
 * import com.pulumi.aws.securityhub.AutomationRuleArgs;
 * import com.pulumi.aws.securityhub.inputs.AutomationRuleActionArgs;
 * import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateArgs;
 * import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateSeverityArgs;
 * import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateNoteArgs;
 * import com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AutomationRule("example", AutomationRuleArgs.builder()
 *             .description("Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk")
 *             .ruleName("Elevate severity of findings that relate to important resources")
 *             .ruleOrder(1)
 *             .actions(AutomationRuleActionArgs.builder()
 *                 .findingFieldsUpdate(AutomationRuleActionFindingFieldsUpdateArgs.builder()
 *                     .severity(AutomationRuleActionFindingFieldsUpdateSeverityArgs.builder()
 *                         .label("CRITICAL")
 *                         .product("0.0")
 *                         .build())
 *                     .note(AutomationRuleActionFindingFieldsUpdateNoteArgs.builder()
 *                         .text("This is a critical resource. Please review ASAP.")
 *                         .updatedBy("sechub-automation")
 *                         .build())
 *                     .types("Software and Configuration Checks/Industry and Regulatory Standards")
 *                     .userDefinedFields(Map.of("key", "value"))
 *                     .build())
 *                 .type("FINDING_FIELDS_UPDATE")
 *                 .build())
 *             .criteria(AutomationRuleCriteriaArgs.builder()
 *                 .resourceIds(AutomationRuleCriteriaResourceIdArgs.builder()
 *                     .comparison("EQUALS")
 *                     .value("arn:aws:s3:::examplebucket/*")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:AutomationRule
 *     properties:
 *       description: Elevate finding severity to CRITICAL when specific resources such as an S3 bucket is at risk
 *       ruleName: Elevate severity of findings that relate to important resources
 *       ruleOrder: 1
 *       actions:
 *         - findingFieldsUpdate:
 *             severity:
 *               label: CRITICAL
 *               product: '0.0'
 *             note:
 *               text: This is a critical resource. Please review ASAP.
 *               updatedBy: sechub-automation
 *             types:
 *               - Software and Configuration Checks/Industry and Regulatory Standards
 *             userDefinedFields:
 *               key: value
 *           type: FINDING_FIELDS_UPDATE
 *       criteria:
 *         resourceIds:
 *           - comparison: EQUALS
 *             value: arn:aws:s3:::examplebucket/*
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Hub automation rule using their ARN. For example:
 * ```sh
 * $ pulumi import aws:securityhub/automationRule:AutomationRule example arn:aws:securityhub:us-west-2:123456789012:automation-rule/473eddde-f5c4-4ae5-85c7-e922f271fffc
 * ```
 * @property actions A block that specifies one or more actions to update finding fields if a finding matches the conditions specified in `Criteria`. Documented below.
 * @property criteria A block that specifies a set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter findings. Documented below.
 * @property description The description of the rule.
 * @property isTerminal Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. Defaults to `false`.
 * @property ruleName The name of the rule.
 * @property ruleOrder An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
 * @property ruleStatus Whether the rule is active after it is created.
 * @property tags
 * */*/*/*/*/*/
 */
public data class AutomationRuleArgs(
    public val actions: Output<List<AutomationRuleActionArgs>>? = null,
    public val criteria: Output<AutomationRuleCriteriaArgs>? = null,
    public val description: Output<String>? = null,
    public val isTerminal: Output<Boolean>? = null,
    public val ruleName: Output<String>? = null,
    public val ruleOrder: Output<Int>? = null,
    public val ruleStatus: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.AutomationRuleArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.AutomationRuleArgs =
        com.pulumi.aws.securityhub.AutomationRuleArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .criteria(criteria?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isTerminal(isTerminal?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .ruleOrder(ruleOrder?.applyValue({ args0 -> args0 }))
            .ruleStatus(ruleStatus?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AutomationRuleArgs].
 */
@PulumiTagMarker
public class AutomationRuleArgsBuilder internal constructor() {
    private var actions: Output<List<AutomationRuleActionArgs>>? = null

    private var criteria: Output<AutomationRuleCriteriaArgs>? = null

    private var description: Output<String>? = null

    private var isTerminal: Output<Boolean>? = null

    private var ruleName: Output<String>? = null

    private var ruleOrder: Output<Int>? = null

    private var ruleStatus: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A block that specifies one or more actions to update finding fields if a finding matches the conditions specified in `Criteria`. Documented below.
     */
    @JvmName("vndcllkdhgebjxnm")
    public suspend fun actions(`value`: Output<List<AutomationRuleActionArgs>>) {
        this.actions = value
    }

    @JvmName("kcqmwdqyejggldba")
    public suspend fun actions(vararg values: Output<AutomationRuleActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values A block that specifies one or more actions to update finding fields if a finding matches the conditions specified in `Criteria`. Documented below.
     */
    @JvmName("keavxqmdaffkxjek")
    public suspend fun actions(values: List<Output<AutomationRuleActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value A block that specifies a set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter findings. Documented below.
     */
    @JvmName("npcvtfsbiryjyvun")
    public suspend fun criteria(`value`: Output<AutomationRuleCriteriaArgs>) {
        this.criteria = value
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("ushbamiprijauwef")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. Defaults to `false`.
     */
    @JvmName("yupugwipqmupfjoi")
    public suspend fun isTerminal(`value`: Output<Boolean>) {
        this.isTerminal = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("nkrobxfmihmxiyyc")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
     */
    @JvmName("kcsibnlmlbrdnlcf")
    public suspend fun ruleOrder(`value`: Output<Int>) {
        this.ruleOrder = value
    }

    /**
     * @param value Whether the rule is active after it is created.
     */
    @JvmName("okeejqinymbflegr")
    public suspend fun ruleStatus(`value`: Output<String>) {
        this.ruleStatus = value
    }

    /**
     * @param value
     */
    @JvmName("vnxherwkkppqfsmh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A block that specifies one or more actions to update finding fields if a finding matches the conditions specified in `Criteria`. Documented below.
     */
    @JvmName("kkpdnkifcjkidvdr")
    public suspend fun actions(`value`: List<AutomationRuleActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument A block that specifies one or more actions to update finding fields if a finding matches the conditions specified in `Criteria`. Documented below.
     */
    @JvmName("rsdxofqvwcxlnxmy")
    public suspend fun actions(argument: List<suspend AutomationRuleActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument A block that specifies one or more actions to update finding fields if a finding matches the conditions specified in `Criteria`. Documented below.
     */
    @JvmName("gobxturqrukukxcw")
    public suspend fun actions(vararg argument: suspend AutomationRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument A block that specifies one or more actions to update finding fields if a finding matches the conditions specified in `Criteria`. Documented below.
     */
    @JvmName("ehnppbdcikvocjaw")
    public suspend fun actions(argument: suspend AutomationRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AutomationRuleActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values A block that specifies one or more actions to update finding fields if a finding matches the conditions specified in `Criteria`. Documented below.
     */
    @JvmName("effxnfvxaiafcdhe")
    public suspend fun actions(vararg values: AutomationRuleActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value A block that specifies a set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter findings. Documented below.
     */
    @JvmName("rmylyjjrvrqostno")
    public suspend fun criteria(`value`: AutomationRuleCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.criteria = mapped
    }

    /**
     * @param argument A block that specifies a set of ASFF finding field attributes and corresponding expected values that Security Hub uses to filter findings. Documented below.
     */
    @JvmName("hcbgfhbjxjkewolm")
    public suspend fun criteria(argument: suspend AutomationRuleCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = AutomationRuleCriteriaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param value The description of the rule.
     */
    @JvmName("ybcblyovrrkykoub")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. Defaults to `false`.
     */
    @JvmName("rgdthfekcedioxsf")
    public suspend fun isTerminal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isTerminal = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("yecypwctadponjqg")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
     */
    @JvmName("ubiyrlcoxqaaxpan")
    public suspend fun ruleOrder(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleOrder = mapped
    }

    /**
     * @param value Whether the rule is active after it is created.
     */
    @JvmName("mspxtjmiqrgreijv")
    public suspend fun ruleStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleStatus = mapped
    }

    /**
     * @param value
     */
    @JvmName("lwrqtvolkygvhvaf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("rwanhfbdopietgts")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AutomationRuleArgs = AutomationRuleArgs(
        actions = actions,
        criteria = criteria,
        description = description,
        isTerminal = isTerminal,
        ruleName = ruleName,
        ruleOrder = ruleOrder,
        ruleStatus = ruleStatus,
        tags = tags,
    )
}
